<?php

namespace App\Http\Controllers;

use App\Models\Period;
use App\Models\Semester;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

  public $cyear;
  public $csession;

  public $csemester;

  function __construct()
  {
    $per=Period::where('status',1);
    if($per->exists()){
      $pg = $per->first();
      $this->cyear=$pg->c_year;
      $this->csession=$pg->c_session;

    }else{
      return view('errors.429')->with(["msg"=>'Improper Session Setup.']);

    }
    $perr=Semester::where('status',1);
    if($perr->exists()){
      $pg = $perr->first();
      $this->csemester=$pg->id;

    }else{
      return view('errors.429')->with(["msg"=>'Improper Semester Setup.']);

    }
    return '';
  }

  static function cleaninput($input){
    return htmlentities(strip_tags(trim($input)));
  }


  static function currentPeriod(){
    $per=Period::where('status',1);
    if($per->exists()){
      return $per->first();
    }else{
      return abort(403, 'Improper Setup Period.');
    }
  }


  static function currentSemester(){
    $per=Semester::where('status',1);
    if($per->exists() ){
      return $per->first();
    }else{
      return abort(403, 'Improper Setup Period.');
    }
  }



}
