<?php

namespace App\Http\Controllers;

use App\Models\Period;
use App\Models\Result;
use App\Http\Requests\StoreResultRequest;
use App\Http\Requests\UpdateResultRequest;
use App\Models\Semester;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ResultController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {

      $results = Result::where(['student'=>Auth::user()->email])->with('resultcourse')->get();
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function semesterResult(Request $request)
    {
      $allperiods = Period::all();
      $allsemesters = Semester::all();
      if ($request->isMethod('post')) {
        $semester = Semester::find($request->sem);
        $period = Period::where('c_year', $request->sess)->first();
      }else{
        $semester = Semester::where('status', 1)->first();
        $period = Period::where('status', 1)->first();
      }
      $result=Result::where(["student_reg"=>\auth()->user()->reg_number,"semester"=>$semester->id,"year"=>$period->c_year])->with('resultcourse')->get();
      return view('results.student_result', compact('result','semester','period','allperiods','allsemesters'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreResultRequest $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Result $result)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Result $result)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateResultRequest $request, Result $result)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Result $result)
    {
        //
    }
}
