<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Http;

class Payment extends Model
{
    /** @use HasFactory<\Database\Factories\PaymentFactory> */
    use HasFactory;

    static function checkTuition($std,$year)
    {
      $pay=Payment::where(["student"=>$std,"fee_type"=>"TUITION","payment_year"=>$year]);
      if($pay->doesntExist()){
        //student has not paid
        return ['pay'=>0,];
      }else{

        return ['pay'=>1,'paydit'=>$pay->first()];
      }


    }
  static function checkPayment($std,$year,$ptype): int
  {
    $pay=Payment::where(["student"=>$std,"fee_type"=>$ptype,"payment_year"=>$year]);
    if($pay->doesntExist()){
      //student has not paid
      return 0;
    }else{
      $pp=$pay->first();
      if ($pp->status=="pending") {
        return 0;
      }elseif ($pp->status=="paid") {
        return  1;
      }else{
        return  2;
      }
    }


  }

  static function checkTuitionPayment($std,$lvl): int
  {
    $pay=Payment::where(["student"=>$std,"fee_type"=>"TUITION","student_level"=>$lvl]);
    if($pay->doesntExist()){
      //student has not paid
      return 0;
    }else{
      $pp=$pay->first();
      if ($pp->status=="pending") {
        return 0;
      }elseif ($pp->status=="paid") {
        return  1;
      }else{
        return  2;
      }
    }


  }



  protected static function apicall($content){

      $response=Http::withHeaders([
        "Authorization"=>"remitaConsumerKey=".config('remita.MERCHANTID').",remitaConsumerToken=".$content['hash'],
        "Content-Type"=>"application/json",
      ])->post("https://login.remita.net/remita/exapp/api/v1/send/api/echannelsvc/merchant/api/paymentinit",$content['content']);

      if($response->status() == 200) {
        $json_start = strpos($response->body(), '(');
        if ($json_start === false) {
          $bd=json_decode($response->body(),true);
        }else {
          $jsonData = substr($response->body(), 7, -1);
          $bd = json_decode($jsonData, true);
        }

       if($bd['status']=="Payment Reference generated"){
        return $bd;
        }else{
         throw new \Exception("Provider server Failure, please try again in 30 minutes time");
       }
      }else{
        throw new \Exception("Server Failure, please contact ICT unit");
      }


  }

  protected static function VerifyPaymentOrderId($oid){
    $mert =  config('remita.MERCHANTID');
    $api_key =  config('remita.APIKEY');
    $concatString = $oid . $api_key . $mert;
    $hash = hash('sha512', $concatString);
    $url    = config('remita.CHECKSTATUSURL') . '/' . $mert  . '/' . $oid . '/' . $hash . '/' . 'orderstatus.reg';
    $response = Http::get($url);
    if($response->status() == 200) {
    return json_decode($response->body(),true);
    }else{
      throw new \Exception("Server Failure, please contact ICT unit");
    }

  }

  protected static function VerifyPaymentRrr($rrr){
    $mert =  config('remita.MERCHANTID');
    $api_key =  config('remita.APIKEY');
    $concatString = $rrr . $api_key . $mert;
    $hash = hash('sha512', $concatString);
    $url    = config('remita.CHECKSTATUSURL') . '/' . $mert  . '/' . $rrr . '/' . $hash . '/' . 'status.reg';
    $response = Http::get($url);
    if($response->status() == 200) {
      return json_decode($response->body(),true);
    }else{
      throw new \Exception("Server Failure, please contact ICT unit");
    }
  }






}
