<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Result extends Model
{
    /** @use HasFactory<\Database\Factories\ResultFactory> */
    use HasFactory;

    function resultcourse()
    {
      return $this->belongsTo(Courses::class,'course_id');
    }

    function resultadmin()
    {
      return $this->belongsTo('App\Models\Admin','admin_id');
    }

    static function getSingleResult($courseId,$student,$semester,$session)
    {
      return Result::where('course_id',$courseId)->where('student',$student)->where('semester',$semester)->where('session',$session)->first();

    }
}
