<?php

namespace App\Http\Controllers;

use App\Imports\ResultsImport;
use App\Models\Courses;
use App\Http\Requests\StoreCoursesRequest;
use App\Http\Requests\UpdateCoursesRequest;
use App\Models\Department;
use App\Models\DummyResult;
use App\Models\Period;
use App\Models\Semester;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class CoursesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function uploadCourse(Request $request)
    {
      if ($request->isMethod('get')) {
        $periods = Period::all();
        $semesters = Semester::all();
        $dept=Department::all();
        return view('admin.course.upload_courses', compact('periods','semesters','dept'));
      }else{

        $request->validate([
          'course' => 'required|file|mimes:csv,xlsx'

        ]);
        $sess= $request->year . '/' . ($request->year + 1);
        try {
          $admin=Auth::guard('admin')->user()->id;
          DB::statement("TRUNCATE TABLE dummy_courses");
          Excel::import(new ResultsImport($request->sem,$request->course,$request->year,$sess,$admin), $request->file('course'));
          $gh=DB::statement("UPDATE `dummy_courses` a, users b SET a.student_id=b.id WHERE a.student_reg=b.reg_number AND a.student_id is NULL; ");

          $result=DummyResult::with(['dummyresultcourse','dummyresultadmin'])->get();
          return view('admin.result.verify-upload', compact('result'));
          //return back()->with('success', 'Result imported successfully!');
        }catch (\Exception $exception){
          //dd($exception->failures());
          return back()->with('error', $exception->getMessage());
        }


      }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreCoursesRequest $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Courses $courses)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Courses $courses)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateCoursesRequest $request, Courses $courses)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Courses $courses)
    {
        //
    }
}
