<?php

namespace App\Http\Controllers;

use App\Models\Department;
use App\Models\Fee;
use App\Models\Payment;
use App\Models\Payment_rrr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;


class PaymentController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

  public function PayTuition(Request $request){
    $request->validate([
      'popt' => ['required'],
      'plevel' => ['required'],
      'pyear' => ['required'],
      'psem'=>['required'],
    ]);
    $user=Auth::user();
  if($request->plevel>1){
    $check=Payment::checkTuitionPayment(\auth()->user()->email,$request->plevel);
    switch($check){
      case 0:
        $msg="You have not paid the previous year tuition";
        return redirect()->back()->withErrors(["msg"=>$msg]);
        break;
      case 2:
         $msg="You have not Completed the previous year tuition";
        return redirect()->back()->withErrors(["msg"=>$msg]);
         break;
    }

  }
  $check=Payment::checkTuition($user->email,$request->pyear);
  if ($check['pay']==1){
    return redirect()->route('listrrr',$check['paydit']->id);

  }

    $fee=Fee::getFee(auth()->user()->department_id,$request->plevel);
    $dept=Department::find(auth()->user()->department_id);
      $pid=(string) Str::uuid();
      switch ($request->popt){
        case 0:
          $totalAmount=$fee->full_amount;
          break;
        case 1:
          $totalAmount=$fee->first_semester_amount;
          break;
        case 2:
           $totalAmount=$fee->second_semester_amount;
           break;
        default:
           $totalAmount=$fee->full_amount;
      }

      $orderID = $pid;
      $service_type_id=$fee->service_type_id;
      $payerName = $user->surname.' '.$user->other_names;
      $hash_string = config('remita.MERCHANTID') . $service_type_id . $orderID . $totalAmount . config('remita.APIKEY');
      $hash = hash('sha512', $hash_string);
//The JSON data.
      $cont=[
        "serviceTypeId"=>$service_type_id,
        "amount"=>$totalAmount,
        "hash"=>$hash,
        "orderId"=>$pid,
        "payerName"=>$payerName,
        "payerEmail"=> auth()->user()->email,
        "payerPhone"=>auth()->user()->phone,
        "description"=>"Payment For ".strtoupper($fee->name),
        "customFields"=>[
          [
            "name"=> "Students Reg. No",
            "value"=> auth()->user()->reg_number,
            "type"=> "ALL"
          ],
          [
            "name"=> "department",
            "value"=> $dept->name,
            "type"=> "ALL"
          ],
          [
          "name"=> "payYear",
          "value"=> $request->pyear,
          "type"=> "ALL"
          ],
          [
          "name"=> "payLevel",
              "value"=> $request->plevel,
              "type"=> "ALL"
            ]

        ]
      ];
     // $content=json_encode($cont);

    try {
      $responsevalue= Payment::apicall(array('content'=>$cont,'hash'=>$hash,'amount'=>$totalAmount,'type'=>$fee->name));
      $wtdb=$this->writePayment($user->email,$fee->name,$request->pyear,$request->pyear,$request->plevel,
        $request->popt,$fee->full_amount,$totalAmount,$orderID,$responsevalue['RRR']);

      return redirect()->route('listrrr',$wtdb);
    }catch (\Exception $e){
      Log::error('Payment Error: ' . $e->getMessage(), [
        'file' => $e->getFile(),
        'line' => $e->getLine(),
        'trace' => $e->getTraceAsString(),
      ]);

      return view('errors.404')->withErrors(["msg"=>$e->getMessage()]);
    }
       //return array('response'=>$responsevalue,'orderid'=>$orderID,'amount'=>$totalAmount,'semester'=>$sem,'type'=>$type);



  }


  function writePayment($student,$feetype,$sess,$year,$lvl,$foh,$famount,$amtpaid,$orderid,$rrr){
      if (strtolower($feetype)=="tuition"){

          $check=Payment::where(['student'=>$student,'payment_year'=>$year,'student_level'=>$lvl,'fee_type'=>$feetype]);
          if($check->doesntExist()){
            $outstanding=$famount-$amtpaid;
            $pay=Payment::insertGetId([
              'student'=>$student,
              'payment_year'=>$year,
              'student_level'=>$lvl,
              'fee_type'=>$feetype,
              'payment_session'=>$sess,
              'amount_payable'=>$famount,
              'amount_paid'=>$amtpaid,
              'outstanding'=>$outstanding,
              'status'=>'pending',
              'mp'=>$foh
            ]);
          }else{
            if($foh !=0){
            $payy=$check->first();
            $ttpay=$payy->amount_paid+$amtpaid;
            $outstanding=max($payy->amount_payable-$ttpay,0);
            $payy->mp=$foh;
            $payy->amount_paid=$ttpay;
            $payy->outstanding=$outstanding;
            $payy->save();
            $pay=$payy->id;
            }else{
              $pay=Payment::insertGetId([
                'student'=>$student,
                'payment_year'=>$year,
                'student_level'=>$lvl,
                'fee_type'=>$feetype,
                'payment_session'=>$sess,
                'amount_payable'=>$famount,
                'amount_paid'=>$amtpaid,
                'outstanding'=>0,
                'status'=>'pending',
                'mp'=>$foh
              ]);
            }

          }

      }else{
        $pay=Payment::insertGetId([
          'student'=>$student,
          'payment_year'=>$year,
          'student_level'=>$lvl,
          'fee_type'=>$feetype,
          'payment_session'=>$sess,
          'amount_payable'=>$famount,
          'amount_paid'=>$amtpaid,
          'outstanding'=>0,
          'status'=>'pending',
          'mp'=>$foh
        ]);
      }

      /// write rrr to database
    $payrrr= new Payment_rrr;
      $payrrr->payment_id=$pay;
    $payrrr->student=$student;
     $payrrr->order_id=$orderid;
      $payrrr->rrr=$rrr;
      $payrrr->amount=$amtpaid;
      $payrrr->payment_date='';
      $payrrr->transaction_time=NOW();
      $payrrr->message='Awaiting Payment';
      $payrrr->status='0';
    $payrrr->save();

    return $pay;


  }






}
