<?php

namespace App\Http\Controllers;

use App\Models\CourseForm;
use App\Models\Courses;
use App\Models\Department;
use App\Models\LoadedCourses;
use App\Models\Payment;
use App\Models\Payment_rrr;
use App\Models\Period;
use App\Models\Result;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Str;

class TransferController extends Controller
{
    //
  function index($email,$regnumb)
  {
    $pageConfigs = ['myLayout' => 'blank'];
    return view('content.authentications.transferpage',compact('email','regnumb','pageConfigs'));
  }

  function getdata(Request $request){
    //// get student information
    /// get student fees
    /// get student course form
    /// get student result
    ///
    $request->validate([
      'email' => ['required','email'],
      'regnumber' => ['required','numeric','digits_between:8,10'],
    ]);

    /////check if email exist for another user
    if(User::where('email',$request->email)->where('regno', '!=',$request->regnumber)->exists()){
      return back()->withErrors(['error'=>"This email has already being used by another Student"]);
    }

    ////get student profile data
    $profile=DB::connection('olddb')->table('student')->where('regno',$request->regnumber);
    if($profile->exists()){
      $data=$profile->first();

      $user=User::where('reg_number',$data->regnumber);
      if ($user->doesntExist()){

        ///create new row
        $user=new User;
        $user->email = $data->email ;
        $user->phone = $data->fone ;
        $user->reg_number = $data->regno ;
        $user->jamb_number = $data->jamb ;
        $user->surname = $data->sname ;
        $user->other_names = $data->fname." ".$data->oname ;
        $user->prog_id = $data->prog ;
        $user->faculty_id = $data->sch ;
        $user->department_id = $data->dept ;
        $user->s_level = $data->level ;
        $user->gender = $data->sex ;
        $user->dob = $data->dob ;
        $user->marital_status = $data->mstatus ;
        $user->nationality = "Nigerian" ;
        $user->state = $data->state ;
        $user->lga = $data->lga ;
        $user->home_town = $data->htown ;
        $user->address = $data->adrex ;
        $user->place_of_birth = $data->pbirth ;
        $user->parent_title = $data->title ;
        $user->parent_name = $data->pname." ".$data->pfname ;
        $user->parent_phone = $data->pfone ;
        $user->parent_email = $data->pmail ;
        $user->next_of_kin_name = $data->nxtname ;
        $user->next_of_kin_phone = $data->nxtfone ;
        $user->next_of_kin_email = "null" ;
        $user->next_of_kin_relationship = $data->nextrel ;
        $user->next_of_kin_address = $data->nextadrex ;
        $user->primary_school = $data->mskul ;
        $user->primary_school_start = $data->mskulfrm ;
        $user->primary_school_end = $data->mskulto ;
        $user->secondary_school = $data->mskul2 ;
        $user->secondary_school_start = $data->mskul2frm ;
        $user->secondary_school_end = $data->mskul2to ;
        $user->secondary_school_Certificate = $data->qualification2 ;
        $user->tertiary_school = $data->mskl3 ;
        $user->tertiary_school_start = $data->mskul3frm ;
        $user->tertiary_school_end = $data->mskulto ;
        $user->tertiary_school_Certificate = $data->qualification3 ;
//        $user->tertiary_course_1 = $data-> ;
//        $user->tertiary_course_1_grade = $data-> ;
//        $user->tertiary_course_2 = $data-> ;
//        $user->tertiary_course_2_grade = $data-> ;
//        $user->tertiary_course_3 = $data-> ;
//        $user->tertiary_course_3_grade = $data-> ;
//        $user->tertiary_course_4 = $data-> ;
//        $user->tertiary_course_4_grade = $data-> ;
        $user->avatar = $data->img ;
        $user->status = $data->status ;
        $user->transferred_by = $data->staf ;
        $user->entry_type = $data->entry_type ;
        $user->entry_year = $data->entry_year ;
        $user->entry_session = $data->entry_session ;
        $user->campus = "NOCEN" ;
        $user->save();
      }
      $user->email = $request->email ;
      $user->save();

      $dept=Department::find($user->department_id);
      $startyear=substr($user->reg_number, 0, 4);
      if($dept->levels>=$user->s_level){
        $feehist=Period::where('c_year', '>=',$startyear)->orderBy('c_year', 'asc')->offset(0)->limit($user->s_level)->get();
      }else{
        $feehist=Period::where('c_year', '>=',$startyear)->orderBy('c_year', 'asc')->offset(0)->limit($dept->levels)->get();
      };

      foreach($feehist as $fee){
        $paymen=DB::connection('olddb')->table('paid_std_archive')->where(['student'=>$request->regnumber,'cyear'=>$fee]);
        $cus1=DB::connection('olddb')->table('student_course_archive')->where(['student'=>$request->regnumber,'yr'=>$fee,'semester'=>1]);
        $cus2=DB::connection('olddb')->table('student_course_archive')->where(['student'=>$request->regnumber,'yr'=>$fee,'semester'=>2]);

        ///handle fees
        if($paymen->exists()){
          $payment=$paymen->get();
          $payable=new Payment();
          $payable->user_id =$user->id;
          $payable->student =$user->email;
          $payable->fee_type =$payment[0]->feetype;
          $payable->payment_session =$payment[0]->cyear.'/'.$payment[0]->cyear+1;
          $payable->payment_year =$payment[0]->cyear;
          $payable->student_level =$payment[0]->level;
          $payable->mp =count($payment);
          $payable->amount_payable =$paymen->sum('amt');
          $payable->amount_paid =$payment[0]->amt;
          $payable->outstanding =0;
          $payable->status =$payment[0]->status;
          $payable->save();

          foreach ($payment as $p) {
            $rrr=new Payment_rrr();
            $rrr->payment_id= $payable->id ;
            $rrr->student= $p->email ;
            $rrr->order_id= $p->orderid ;
            $rrr->rrr= $p->rrr ;
            $rrr->amount= $p->amt ;
            $rrr->payment_date= $p->paydate ;
            $rrr->transaction_time= $p->transdate ;
            $rrr->message= $p->message ;
            $rrr->status= $p->status ;
            $rrr->save();
          }

        }
        //handle course form
        if($cus1->exists()){
          $cc=$cus1->get();
          $cusform=new CourseForm;
          $cusform->student_id = $user->id;
          $cusform->session =$cc[0]->yr.'/'.$cc[0]->yr ;
          $cusform->semester =$cc[0]->semester;
          $cusform->student_level =$cc[0]->lvl ;
          $cusform->printed_on =$cc[0]->loaddate ;
          $cusform->pc_ip = $cc[0]->locate;
          $cusform->admin_id = $cc[0]->admin;
          $cusform->form_code =Str::uuid7()->toString();
          $cusform->save();
          foreach ($cc as $c) {
            $cid=Courses::where('code',$c->course)->first()->id;
            $lcus= new LoadedCourses;
            $lcus->course_form_id =$cusform->id;
            $lcus->student_id =$user->id;
            $lcus->course_id =$cid->id;
            $lcus->course_load =$c->cload ;
            $lcus->carry_over =0 ;
            $lcus->admin_id =$c->admin;
            $lcus->save();
          }

        }
        if($cus2->exists()){
          $cc=$cus2->get();
          $cusform=new CourseForm;
          $cusform->student_id = $user->id;
          $cusform->session =$cc[0]->yr.'/'.$cc[0]->yr ;
          $cusform->semester =$cc[0]->semester;
          $cusform->student_level =$cc[0]->lvl ;
          $cusform->printed_on =$cc[0]->loaddate ;
          $cusform->pc_ip = $cc[0]->locate;
          $cusform->admin_id = $cc[0]->admin;
          $cusform->form_code =Str::uuid7()->toString();
          $cusform->save();
          foreach ($cc as $c) {
            $cid=Courses::where('code',$c->course)->first()->id;
            $lcus= new LoadedCourses;
            $lcus->course_form_id =$cusform->id;
            $lcus->student_id =$user->id;
            $lcus->course_id =$cid->id;
            $lcus->course_load =$c->cload ;
            $lcus->carry_over =0 ;
            $lcus->admin_id =$c->admin;
            $lcus->save();
          }

        }

        }
      /////handle result
      $result=DB::connection('olddb')->table('result_archive')->where(['student'=>$request->regnumber]);
      if ($result->exists()) {
        $res=$result->get();
        foreach ($res as $r) {
          $sres=new Result;
          $sres->student_id= $user->id; ;
          $sres->course_id= Courses::where('code',$r->course)->first()->id; ;
          $sres->session= $r->csession ;
          $sres->year= $r->cyear ;
          $sres->semester= $r->semester ;
          $sres->ca_score= $r->cascore ;
          $sres->grade= "null" ;
          $sres->exam_score= $r->examscore ;
          $sres->total_score= $r->score ;
          $sres->admin_id= $r->admin;
        }
      }
      $user->status=1;
      $user->save();
      Password::sendResetLink(
        $request->email
      );

    }else{
      return back()->withErrors(['error'=>'Registration number does not exist']);
    }


  }







}
