<?php

namespace App\Http\Controllers;

use App\Models\Department;
use App\Models\Fee;
use App\Models\Period;
use App\Models\Tuition;
use App\Http\Requests\UpdateTuitionRequest;

class TuitionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
      $user = auth()->user();
      $dept=Department::find($user->department_id);
      if ($dept==null)
      {abort(429,"Your department has not been set up please contact the ICT office."); }

      $startyear=substr($user->reg_number, 0, 4);
      if($dept->levels>=$user->s_level){
        $feehist=Period::where('c_year', '>=',$startyear)->orderBy('c_year', 'asc')->offset(0)->limit($user->s_level)->get();
      }else{
        $feehist=Period::where('c_year', '>=',$startyear)->orderBy('c_year', 'asc')->offset(0)->limit($dept->levels)->get();
        };

      //check if student is an extra year

      return view('fees.tuition',["feehist"=>$feehist,'user'=>$user]);
    }


}
