<?php

namespace App\Imports;

use App\Models\Course;
use App\Models\DummyCourse;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class CoursesImport implements ToModel, WithHeadingRow, WithBatchInserts, WithChunkReading
{

  private $department;
  private $level;
  private $semester;
  function __construct($semester,$level,$department)
  {
    $this->semester = $semester;
    $this->level = $level;
    $this->department = $department;


  }

    public function model(array $row)
    {
        return new DummyCourse([
          "code"=>$row['grade'],
          "name"=>$row['name'],
          "credit_unit"=>$row['credit load'],
          "semester"=>$this->semester,
          "level"=>$this->semester,
          "department_id"=>$this->semester,
        ]);
    }

  public function batchSize(): int
  {
    return 200;
  }

  public function chunkSize(): int
  {
    return 200;
  }
}
