<?php

namespace App\Imports;

use App\Models\DummyResult;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class ResultsImport implements ToModel, WithHeadingRow, WithBatchInserts, WithChunkReading
{
  private  $semester;
  private  $course;
  private $year;
  private $sess;
  private $admin;


  function __construct($semester,$course,$year,$sess,$admin)
  {
    $this->semester = $semester;
    $this->course = $course;
    $this->year = $year;
    $this->sess = $sess;
    $this->admin = $admin;

     }
    /**
    * @param array $row,
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        return new DummyResult([
          "student_reg" => $row['student_reg'],
            "ca_score"=>$row['ca_score'],
            "exam_score"=>$row['exam_score'],
            "total_score"=>$row['total_score'],
            "grade"=>$row['grade'],
            "semester"=>$this->semester,
            "course_id"=>$this->course,
            "year"=>$this->year,
            "session"=>$this->sess,
            "admin_id"=>$this->admin
            //
        ]);
    }

//      public function rules(): array
//      {
//        return [
//          'student_reg' => Rule::in(['integer']),
//          'ca_score' => Rule::in(['numeric','max_digits:2']),
//          'exam_score' => Rule::in(['numeric','max_digits:3']),
//          'total_score' => Rule::in(['numeric','max_digits:3']),
//          'grade' => Rule::in(['alpha:ascii','size:1']),
//        ];
//      }

//  public function customValidationMessages()
//  {
//    return [
//      'student_reg.in' => 'An unknown Reg number is included in the result, please verify and correct it.',
//    ];
//  }

  public function batchSize(): int
  {
    return 500;
  }

  public function chunkSize(): int
  {
    return 500;
  }

}
