<?php

namespace App\Models;

use App\Notifications\Adminpasswordrecovery;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class Admin extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\AdminFactory> */
  use HasApiTokens, HasFactory, Notifiable;


  protected $guard = 'admin';

  protected $fillable = [
    'name', 'email', 'phone', 'role', 'password', 'image','status'
  ];

  protected $hidden = [
    'password', 'remember_token',
  ];

  public function sendPasswordResetNotification($token): void
  {
    $this->notify(new Adminpasswordrecovery($token));
    session()->flash('status','Password Reset Link Sent. Please Check Your Email');
  }
}
