<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LoadedCourses extends Model
{
    /** @use HasFactory<\Database\Factories\LoadedCoursesFactory> */
    use HasFactory;

    static function checkloaded($cid,$student,$semester,$level)
    {
      $cf=CourseForm::where(["student_id"=>$student,'semester'=>$semester,'student_level'=>$level]);
      if ($cf->exists()){
        $cf=$cf->first();
        if(LoadedCourses::where(["course_form_id"=>$cf->id,"course_id"=>$cid])->exists()){
          return "selected";
        }
      }

    }

  function course()
  {
    return $this->belongsTo(Courses::class);
    }

    function courseForm()
    {
      return $this->belongsTo(CourseForm::class);
    }

    function student()
    {
      return $this->belongsTo(User::class);
    }
}
