<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Result extends Model
{
    /** @use HasFactory<\Database\Factories\ResultFactory> */
    use HasFactory;
    protected $fillable=['student_id', 'student_reg', 'course_id', 'session', 'year', 'semester', 'ca_score', 'grade', 'exam_score', 'total_score', 'admin_id'];

    function resultcourse()
    {
      return $this->belongsTo(Courses::class,'course_id');
    }

    function resultadmin()
    {
      return $this->belongsTo('App\Models\Admin','admin_id');
    }

    static function getSingleResult($courseId,$student,$semester,$session)
    {
      return Result::where('course_id',$courseId)->where('student_id',$student)->where('semester',$semester)->where('session',$session)->first();

    }

    static function showGrade($score): array
    {
     if($score>=75 and $score<=100){
       return array("grade"=>"A","point"=>4);
     }elseif ($score>=70 and $score<=74){
       return array("grade"=>"AB","point"=>3.5);
     }elseif ($score>=65 and $score<=69){
       return array("grade"=>"B","point"=>3.25);
     }elseif ($score>=60 and $score<=64){
       return array("grade"=>"BC","point"=>3);
     }elseif ($score>=55 and $score<=59){
       return array("grade"=>"C","point"=>2.75);
     }elseif ($score>=50 and $score<=54){
       return array("grade"=>"CD","point"=>2.50);
     }elseif ($score>=45 and $score<=49){
       return array("grade"=>"D","point"=>2.25);
     }elseif ($score>=40 and $score<=44){
       return array("grade"=>"E","point"=>2);
     }else
       return array("grade"=>"F","point"=>0);
         }




}
