<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->string('student');
            $table->string('fee_type');
            $table->string('payment_session');
            $table->string('payment_year');
            $table->string('student_level');
            $table->integer('mp')->default(1);
            $table->double('amount_payable')->default(0);
            $table->double('amount_paid')->default(0);
            $table->double('outstanding')->default(0);
            $table->string('status')->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
