<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_rrrs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payment_id');
            $table->string('student');
            $table->text('order_id');
            $table->integer('rrr');
            $table->double('amount')->nullable();
            $table->string('payment_date')->nullable();
            $table->string('transaction_time')->nullable();
            $table->string('message')->nullable();
            $table->integer('status')->default(0);
            $table->timestamps();
            $table->foreign('payment_id')->references('id')->on('payments');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_rrrs');
    }
};
