<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('hostels', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('address');
            $table->enum('hostel_type',['Male','Female','Mix'])->comment('male or female');
            $table->string('hostel_owner')->default('NOCEN');
            $table->string('num_of_floors');
            $table->string('num_of_rooms');
            $table->enum('light',['Yes','No'])->default('Yes');
            $table->enum('water',['Yes','No'])->default('Yes');
            $table->enum('aircondition',['Yes','No'])->default('Yes');
            $table->enum('status',['Active','Inactive'])->default('Active');
            $table->string('hostel_manager')->nullable();
            $table->string('hostel_manager_email')->nullable();
            $table->string('hostel_manager_phone')->nullable();
            $table->string('image')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hostels');
    }
};
