@extends('layouts/layoutMaster')

@section('title', 'Student Semester Result')

@section('vendor-style')

  <link href="https://cdn.datatables.net/v/bs5/jszip-3.10.1/dt-2.3.4/b-3.2.5/b-html5-3.2.5/b-print-3.2.5/cr-2.1.1/cc-1.1.0/date-1.6.0/fc-5.0.5/fh-4.0.4/kt-2.12.1/r-3.0.7/rg-1.6.0/rr-1.5.0/sc-2.4.3/sb-1.8.4/sp-2.3.5/sl-3.1.2/datatables.min.css" rel="stylesheet" integrity="sha384-sJUMfrejiv5pRmY5qNGZVl4JMtWiZ53QA1/6/7GLLBQdxCJMhOwunSFrcJT3Xlkk" crossorigin="anonymous">

@endsection


@section('page-script')

  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js" integrity="sha384-VFQrHzqBh5qiJIU0uGU5CIW3+OWpdGGJM9LBnGbuIH2mkICcFZ7lPd/AAtI7SNf7" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js" integrity="sha384-/RlQG9uf0M2vcTw3CX7fbqgbj/h8wKxw7C3zu9/GxcBPRKOEcESxaxufwRXqzq6n" crossorigin="anonymous"></script>
  <script src="https://cdn.datatables.net/v/bs5/jszip-3.10.1/dt-2.3.4/b-3.2.5/b-html5-3.2.5/b-print-3.2.5/cr-2.1.1/cc-1.1.0/date-1.6.0/fc-5.0.5/fh-4.0.4/kt-2.12.1/r-3.0.7/rg-1.6.0/rr-1.5.0/sc-2.4.3/sb-1.8.4/sp-2.3.5/sl-3.1.2/datatables.min.js" integrity="sha384-l1GvbIu8PJBS6ck4sP/OSRP0QQcdFEUl82+8qUHmKwkrMllwjkkT2e9gNfIyuSxW" crossorigin="anonymous"></script>
  <script >

    new DataTable('#reslt', {
      layout: {
        topStart: {
          buttons: [
            'copy', 'print', 'pdf'
          ]
        }
      },
      columnDefs: [{
        "defaultContent": "-",
        "targets": "_all"
      }]
    });
  </script>
@endsection

@section('content')
  <h4 class="py-3 breadcrumb-wrapper mb-4">
{{--    <span class="text-muted fw-light">Student /</span>{{$period->c_year}} {{$semester->name}} Result--}}
  </h4>


  <!-- Result List Table -->
  <div class="card">
    <div class="card-header" style="margin: auto"> Rows in Red Contain invalid Student Registration Number Please correct them before uploading again.</div>

    <div class="card-datatable table-responsive">
      <table class="table" id="reslt">
        <thead>
        <tr>

          <th>S/N</th>
          <th>Student</th>
          <th>Course Code</th>
          <th>Course Name</th>
          <th>CA</th>
          <th>Exam</th>
          <th>Total Score</th>
          <th>Grade</th>
          <th>Admin</th>
        </tr>
        </thead>
        <tbody>

          @foreach($result as $resultt)
            <tr @if(\App\Models\DummyResult::checkNumb($resultt->student_reg)==false)style="background-color: red" @endif>
              <td>{{$loop->iteration}}</td>
              <td>{{$resultt->student_reg}}</td>
              <td>{{$resultt->dummyresultcourse->code}}</td>
              <td>{{$resultt->dummyresultcourse->name}}</td>
              <td>{{$resultt->ca_score}}</td>
              <td>{{$resultt->exam_score}}</td>
              <td>{{$resultt->total_score}}</td>
              <td>{{$resultt->grade}}</td>
              <td>{{$resultt->dummyresultadmin->name}}</td>
            </tr>
          @endforeach


        </tbody>
      </table>
    </div>
  </div>

@endsection

