@php
  $customizerHidden = 'customizer-hide';
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Transfer Page')

@section('vendor-style')
  <!-- Vendor -->
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/@form-validation/umd/styles/index.min.css')}}" />
@endsection

@section('page-style')
  <!-- Page -->
  <link rel="stylesheet" href="{{asset('assets/vendor/css/pages/page-auth.css')}}">
@endsection

@section('vendor-script')
  <script src="{{asset('assets/vendor/libs/@form-validation/umd/bundle/popular.min.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/@form-validation/umd/plugin-bootstrap5/index.min.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/@form-validation/umd/plugin-auto-focus/index.min.js')}}"></script>
@endsection

@section('page-script')
  <script src="{{asset('assets/js/pages-auth.js')}}"></script>
@endsection

@section('content')
  <div class="container-xxl">
    <div class="authentication-wrapper authentication-basic container-p-y">
      <div class="authentication-inner py-4">

        <!-- Register -->
        <div class="card">
          <div class="card-body">
            <!-- Logo -->
            <div class="app-brand justify-content-center">
              <a href="{{url('/admin/auth/login')}}" class="app-brand-link gap-2">
                <span class="app-brand-logo demo">@include('_partials.macros')</span>
                <span class="app-brand-text demo h3 mb-0 fw-bold">Data Transfer Page</span>
              </a>
            </div>
            <!-- /Logo -->

            <p class="mb-4" style="text-align: justify">Please confirm the detail below. if correct click the button to migrate your data to the new portal. Ensure you email you are filling in is active, a password reset link will be sent to it</p>
            @if(session()->has('errors'))
              <div class="alert alert-danger alert-dismissible d-flex align-items-center" role="alert">
                {{session('errors')->first() }}

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                </button>
              </div>
            @endif
            @if(session()->has('error'))
              <div class="alert alert-warning alert-dismissible d-flex align-items-center" role="alert">
                {{session()->get('error')}}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                </button>
              </div>
            @endif
            <form id="formAuthentication" class="mb-3" action="{{route('post.data.for.transfer')}}" method="post">
              @csrf
              <div class="mb-3">
                <label for="email" class="form-label">Email</label>
                <input type="email" class="form-control" id="email" name="email"
                       value="{{$email}}" autofocus>
              </div>

              <div class="mb-3">
                <label for="regnumber" class="form-label">Registration Number</label>
                <input type="text" class="form-control" id="regno" name="regno" value="{{$regnumb}}" autofocus>
              </div>


              <button class="btn btn-primary d-grid w-100">
                Verify and transfer
              </button>
            </form>



          </div>
        </div>
        <!-- /Register -->
      </div>
    </div>
  </div>
@endsection
