@php
  use App\Models\Fee;use App\Models\Payment;$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Tuition')

@section('vendor-style')
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')}}">
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css')}}">
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css')}}">

@endsection

@section('vendor-script')
  <script src="{{asset('assets/vendor/libs/moment/moment.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js')}}"></script>
@endsection


@section('content')
  <h4 class="py-3 breadcrumb-wrapper mb-4">
    <span class="text-muted fw-light">Course /</span> Forms
  </h4>

  @error('msg')
  <div class="alert alert-danger alert-dismissible d-flex align-items-center" role="alert">
    <i class="bx bx-xs bx-detail me-2"></i>
    {{$message }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
    </button>
  </div>

  @enderror

  <!-- Bootstrap Table with Header - Dark -->
  <div class="card">
    {{--    <h5 class="card-header">Dark Table head</h5>--}}
    <div class="table-responsive text-nowrap">
      <table class="table">
        <thead class="table-dark">
        <tr>
          <th>S/N</th>
          <th>Session</th>
          <th>Level</th>
          <th>Semester</th>
          <th>Printed On</th>
          <th>Actions</th>
        </tr>
        </thead>
        <tbody class="table-border-bottom-0">
        @foreach($cusfom as $f)
          <tr>
            <td><span class="fw-medium">{{$loop->iteration}}</span></td>
            <td><span class="fw-medium">{{$f->session}}</span></td>
            <td>
              {{$f->student_level}}00 Level
            </td>

            <td>@if($f->semester==1) First Semester @else Second Semester @endif</td>

            <td> {{$f->printed_on}}</td>
            <td>
              <a href="{{route("course.printed",$f->id)}}" class="btn btn-label-primary d-grid w-100 mb-3">
                View
              </a>
            </td>

          </tr>
        @endforeach
        </tbody>
      </table>
    </div>
  </div>
  <!--/ Bootstrap Table with Header Dark -->

@endsection

