@php
  use App\Models\Fee;use App\Models\Payment;$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Tuition')

@section('vendor-style')
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')}}">
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css')}}">
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css')}}">

@endsection

@section('vendor-script')
  <script src="{{asset('assets/vendor/libs/moment/moment.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js')}}"></script>
@endsection

@section('page-script')

  <script>
    $('#modalCenter').on('show.bs.modal',  function (event) {

      var button = $(event.relatedTarget); // Button that triggered the modal
      var lvl = button.data('level'); // Extract info from data-* attributes
      var yer = button.data('year');
      var sem = button.data('sem');
      var nsem = button.data('nsem');
      var famt = button.data('famount');
      var hamt = button.data('halfamt');
      var modal = $(this);
      modal.find('.modal-title').text('Pay Tuition for ' + lvl +"00 Level");
      modal.find('.modal-body input#paylvl').val(lvl);
      modal.find('.modal-body input#payyear').val(yer);
      modal.find('.modal-body input#paysem').val(sem);
      // modal.find('.modal-body input#semest').val(famt);
      modal.find('.modal-body #amt').text("₦ "+famt);
      modal.find('.modal-body #wsem').text("Part Payment ("+nsem+")");
      // modal.find('.modal-body input#semest2').val(hamt);
      modal.find('.modal-body #amt2').text("₦ "+hamt);

    });

    $("input:checkbox").on('click', function() {
      // in the handler, 'this' refers to the box clicked on
      var $box = $(this);
      if ($box.is(":checked")) {
        // the name of the box is retrieved using the .attr() method
        // as it is assumed and expected to be immutable
        var group = "input:checkbox[name='" + $box.attr("name") + "']";
        // the checked state of the group/box on the other hand will change
        // and the current value is retrieved using .prop() method
        $(group).prop("checked", false);
        $box.prop("checked", true);
      } else {
        $box.prop("checked", false);
      }
    });
  </script>
@endsection

@section('content')
  <h4 class="py-3 breadcrumb-wrapper mb-4">
    <span class="text-muted fw-light">Student /fees/</span> RRR
  </h4>
  @isset($msg)
    <div class="alert alert-info alert-dismissible d-flex align-items-center" role="alert">
      <i class="bx bx-xs bx-detail me-2"></i>
      {{$msg }}
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
      </button>
    </div>

  @endisset

  @error('msg')
  <div class="alert alert-danger alert-dismissible d-flex align-items-center" role="alert">
    <i class="bx bx-xs bx-detail me-2"></i>
    {{$message }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
    </button>
  </div>

  @enderror

  <!-- Bootstrap Table with Header - Dark -->
  <div class="card">
    {{--    <h5 class="card-header">Dark Table head</h5>--}}
    <div class="table-responsive text-nowrap">
      <table class="table">
        <thead class="table-dark">
        <tr>

          <th>Year</th>
          <th>Level</th>
          <th>Amount Paid</th>
          <th>RRR</th>
          <th>status</th>
          <th>Actions</th>
        </tr>
        </thead>
        <tbody class="table-border-bottom-0">

        @foreach($rrr as $f)
          <tr>

            <td>
              {{$payment->payment_year}}
            </td>
            <td>
              {{$payment->student_level}}
            </td>
            <td>&#8358; {{$f->amount}}
            </td>
            <td><span class="badge bg-label-primary me-1">{{$f->rrr}}</span></td>
            @if($f->status==0)
            <td>
              <span class="badge bg-label-warning me-1">Not Paid</span>
            </td>
              <td>
                <div class="row">
                  <div class="col-6">
                <a class="btn btn-primary w-55 my-3" href="{{route('paymentverification',$f->rrr)}}"  style="color: white">Verify Payment</a>
                </div>
                <div class="col-6">
                <form method="post" action="{{config('remita.GATEWAYRRRPAYMENTURL') }}">
                  <input id="merchantId" name="merchantId" value="{{config('remita.MERCHANTID')}}" type="hidden"/>
                  <input id="rrr" name="rrr" value="{{$f->rrr}}" type="hidden"/>
                  <input id="responseurl" name="responseurl" value="{{url('/verify/student/payment/'.$f->rrr)}}" type="hidden"/>
                  <input id="hash" name="hash" value="{{$hash}}" type="hidden"/>

                  <button type="submit" class="btn btn-warning w-55 my-3"  style="color: white">Pay Online</button>
                </form>
                </div>
                </div>
              </td>
            @else
              <td>
                <span class="badge bg-label-success me-1"> Paid</span>
              </td>
              <td></td>

            @endif






          </tr>
        @endforeach
        </tbody>
      </table>
    </div>
  </div>
  <!--/ Bootstrap Table with Header Dark -->


@endsection

