<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\authentications\PasswordController;
use App\Http\Controllers\CoursesController;
use App\Http\Controllers\ResultController;
use App\Http\Middleware\AuthAdmins;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Route;



Route::prefix('/admin')->name('admin.')->namespace('App\Http\Controllers\Admin')->group(function(){
  //All the admin routes will be defined here...

  Route::get('confirm-password', function () {

    return view('admin.auth.confirm-password');

  })->middleware([AuthAdmins::class])->name('password.confirm');


  Route::post('/confirm-password', function (Request $request) {
    if (! Hash::check($request->password, $request->user(guard: 'admin')->password)) {
      return back()->withErrors([
        'password' => ['The provided password does not match our records.']
      ]);
    }
    $request->session()->passwordConfirmed();
    return redirect()->intended();
  })->middleware([AuthAdmins::class, 'throttle:6,1']);

  Route::namespace('Auth')->group(function(){

    //Login Routes

    Route::get('/','LoginController@showLoginForm')->name('login');
    Route::get('/login','LoginController@showLoginForm')->name('login');
    Route::post('/login','LoginController@login')->name('plogin');
    Route::post('/logout','LoginController@logout')->name('logout');

    //Forgot Password Routes
    Route::get('/password/reset','ForgotPasswordController@showLinkRequestForm')->name('password.request');
    Route::post('/password/email','ForgotPasswordController@sendResetLinkEmail')->name('password.email');

    //Reset Password Routes
    Route::get('/password/reset/{token}','ResetPasswordController@showResetForm')->name('password.reset');
    Route::post('/password/reset','ResetPasswordController@reset')->name('password.update');

  });


  Route::middleware([AuthAdmins::class])->group(function () {

    Route::get('/dashboard', [AdminController::class, 'index'])->name('home');


    #################################### Result Route #################################
    Route::match(['get', 'post'],'upload/result', [ResultController::class, 'uploadResult'])->name('uploadresult');
    Route::get('download/result/template',function (){
      return response()->download(storage_path('app/public/templates/results.csv') ,'result_template.csv',['Content-Type'=>'text/csv']);
    });


    #################################### Student Route #################################
    Route::match(['get', 'post'],'/reset/student/password', [PasswordController::class, 'resetStudentPassword'])->middleware('password.confirm:admin.password.confirm')->name('reset-password');
    Route::match(['get', 'post'],'/list/student/', [PasswordController::class, 'resetStudentPassword'])->middleware('password.confirm:admin.password.confirm')->name('reset-password');


    #################################### Course Route #################################
    Route::match(['get', 'post'],'upload/course', [CoursesController::class, 'uploadCourse'])->name('uploadcourse');
    Route::get('download/course/template',function (){
      return response()->download(storage_path('app/public/templates/courses.csv') ,'course_template.csv',['Content-Type'=>'text/csv']);
    });








  });

});
