<?php


use App\Http\Controllers\authentications\AuthenticatedSessionController;
use App\Http\Controllers\authentications\ConfirmablePasswordController;
use App\Http\Controllers\authentications\EmailVerificationNotificationController;
use App\Http\Controllers\authentications\EmailVerificationPromptController;
use App\Http\Controllers\authentications\PasswordController;
use App\Http\Controllers\authentications\VerifyEmailController;
use App\Http\Controllers\SuperAdminController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\authentications\LoginBasic;
use App\Http\Controllers\authentications\RegisterBasic;

// authentication
Route::get('/', [LoginBasic::class, 'index'])->name('pages-home');
Route::get('/auth/login', [LoginBasic::class, 'index'])->name('auth-login-basic');
Route::get('/auth/register-basic', [RegisterBasic::class, 'index'])->name('auth-register-basic');
Route::get('/auth/forgot-password', [LoginBasic::class, 'forgotPassword'])->name('auth-forgot-password');
//Route::get('/auth/reset-password', [LoginBasic::class, 'resetPassword'])->name('auth-reset-password');
Route::get('super/admin/login', [SuperAdminController::class, 'index'])->name('superadminlogin');
Route::post('student/login', [LoginBasic::class, 'studentLogin'])->name('student-login');
Route::post('student/password/reset/link', [LoginBasic::class, 'passwordResetLink'])->name('student-password-reset-link');
Route::get('reset-password/{token}', [LoginBasic::class, 'resetPassword'])->name('password.reset');
Route::post('student/reset-password/', [LoginBasic::class, 'studentPasswordReset'])->name('reset-password');

Route::middleware('auth:sanctum')->group(function () {
  Route::get('email/verify', EmailVerificationPromptController::class)
    ->name('verification.notice');

  Route::get('verify-email/{id}/{hash}', VerifyEmailController::class)
    ->middleware(['signed', 'throttle:6,1'])
    ->name('verification.verify');

  Route::post('email/verification-notification', [EmailVerificationNotificationController::class, 'store'])
    ->middleware('throttle:6,1')
    ->name('verification.send');

  Route::get('confirm-password', [ConfirmablePasswordController::class, 'show'])
    ->name('password.confirm');

  Route::post('confirm-password', [ConfirmablePasswordController::class, 'store']);

  Route::put('password', [PasswordController::class, 'update'])->name('password.update');

  Route::post('logout', [LoginBasic::class, 'logoutportal'])
    ->name('logout');
});
