<?php

use App\Http\Controllers\CourseFormController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\PaymentRrrController;
use App\Http\Controllers\ResultController;
use App\Http\Controllers\TransferController;
use App\Http\Controllers\TuitionController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\language\LanguageController;
use App\Http\Controllers\pages\MiscError;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


require __DIR__.'/auth.php';
require __DIR__.'/admin.php';

    // Main Page Route

####################### Ajax Routes ###########################
//Route::get('/list/dept/{id}','DepartmentController@listd');
//Route::get('/list/sch/{id}','SchoolController@listsch');
//Route::get('/list/lga/{id}','LgaController@listlga');
//Route::get('/list/sch1/','SchoolController@listschall');

#############################transfer route######################################

  Route::get('/transfer/student/data/{email}/{regnumber}',[TransferController::class,'index'])->name('transfer.student.data');
  Route::post('/post/data/for/transfer',[TransferController::class,'getdata'])->name('post.data.for.transfer');
// locale
    Route::get('lang/{locale}', [LanguageController::class, 'swap']);

// error page
    Route::get('/pages/misc-error', [MiscError::class, 'index'])->name('pages-misc-error');

   ############################## STUDENT MAIN ROUTES ############################################
    Route::middleware('auth:sanctum')->group(function () {
    Route::get('/student/dashboard', [HomeController::class, 'index'])->name('student-home');

    ############################## STUDENT FEES ROUTES ############################################
    Route::get('/student/list/tuition', [TuitionController::class, 'index'])->name('tuition');
    Route::post('/student/pay/tuition', [PaymentController::class, 'PayTuition'])->name('paytuition');
    Route::get('/student/list/rrr/{payid}', [PaymentRrrController::class, 'index'])->name('listrrr');
    Route::get('/verify/student/payment/{rrr}', [PaymentRrrController::class, 'verifyRrr'])->name('paymentverification');

  ############################## STUDENT COURSES ROUTES ############################################
    Route::get('load/student/course/form/{cusid?}', [CourseFormController::class, 'index'])->name('load-course-form');
    Route::get('load/carry/over/{cusid?}', [CourseFormController::class, 'carryover'])->name('load-carry-over');
    Route::match(['get', 'post'],'load/student/old/course/form/', [CourseFormController::class, 'oldform'])->name('old-course-form');
    Route::post('load/course/form', [CourseFormController::class, 'loadCourse'])->name('loadcourses');
    Route::get('list/student/done/course/form/', [CourseFormController::class, 'listdoneform'])->name('course.done');
    Route::get('print/student/course/form/{cusid?}', [CourseFormController::class, 'listform'])->name('course.printed');
    Route::get('course/form/print/{cusid}', [CourseFormController::class, 'cusprint'])->name('course.form.print');
    Route::get('verify/course/form/{cusid}', [CourseFormController::class, 'verifycus'])->name('verify.course');

    ############################## STUDENT RESULT ROUTES ############################################

      //Route::get('all/student/result', [\App\Http\Controllers\ResultController::class, 'index'])->name('viewResult');
      Route::match(['get', 'post'],'student/semester/result', [ResultController::class, 'semesterResult'])->name('viewResult');
      Route::get('student/result/print/{cusid}', [ResultController::class, 'resultprint'])->name('result.print');






    });
