<?php
  use App\Models\Fee;use App\Models\Payment;$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Tuition'); ?>

<?php $__env->startSection('vendor-style'); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css')); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
  <script src="<?php echo e(asset('assets/vendor/libs/moment/moment.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>

  <script>
    $('#modalCenter').on('show.bs.modal',  function (event) {

      var button = $(event.relatedTarget); // Button that triggered the modal
      var lvl = button.data('level'); // Extract info from data-* attributes
      var yer = button.data('year');
      var sem = button.data('sem');
      var nsem = button.data('nsem');
      var famt = button.data('famount');
      var hamt = button.data('halfamt');
      var modal = $(this);
      modal.find('.modal-title').text('Pay Tuition for ' + lvl +"00 Level");
      modal.find('.modal-body input#paylvl').val(lvl);
      modal.find('.modal-body input#payyear').val(yer);
      modal.find('.modal-body input#paysem').val(sem);
      // modal.find('.modal-body input#semest').val(famt);
      modal.find('.modal-body #amt').text("₦ "+famt);
      modal.find('.modal-body #wsem').text("Part Payment ("+nsem+")");
      // modal.find('.modal-body input#semest2').val(hamt);
      modal.find('.modal-body #amt2').text("₦ "+hamt);

    });

    $("input:checkbox").on('click', function() {
      // in the handler, 'this' refers to the box clicked on
      var $box = $(this);
      if ($box.is(":checked")) {
        // the name of the box is retrieved using the .attr() method
        // as it is assumed and expected to be immutable
        var group = "input:checkbox[name='" + $box.attr("name") + "']";
        // the checked state of the group/box on the other hand will change
        // and the current value is retrieved using .prop() method
        $(group).prop("checked", false);
        $box.prop("checked", true);
      } else {
        $box.prop("checked", false);
      }
    });
  </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <h4 class="py-3 breadcrumb-wrapper mb-4">
    <span class="text-muted fw-light">Student /fees/</span> RRR
  </h4>
  <?php if(isset($msg)): ?>
    <div class="alert alert-info alert-dismissible d-flex align-items-center" role="alert">
      <i class="bx bx-xs bx-detail me-2"></i>
      <?php echo e($msg); ?>

      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
      </button>
    </div>

  <?php endif; ?>

  <?php $__errorArgs = ['msg'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
  <div class="alert alert-danger alert-dismissible d-flex align-items-center" role="alert">
    <i class="bx bx-xs bx-detail me-2"></i>
    <?php echo e($message); ?>

    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
    </button>
  </div>

  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

  <!-- Bootstrap Table with Header - Dark -->
  <div class="card">
    
    <div class="table-responsive text-nowrap">
      <table class="table">
        <thead class="table-dark">
        <tr>

          <th>Year</th>
          <th>Level</th>
          <th>Amount Paid</th>
          <th>RRR</th>
          <th>status</th>
          <th>Actions</th>
        </tr>
        </thead>
        <tbody class="table-border-bottom-0">

        <?php $__currentLoopData = $rrr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>

            <td>
              <?php echo e($payment->payment_year); ?>

            </td>
            <td>
              <?php echo e($payment->student_level); ?>

            </td>
            <td>&#8358; <?php echo e($f->amount); ?>

            </td>
            <td><span class="badge bg-label-primary me-1"><?php echo e($f->rrr); ?></span></td>
            <?php if($f->status==0): ?>
            <td>
              <span class="badge bg-label-warning me-1">Not Paid</span>
            </td>
              <td>
                <div class="row">
                  <div class="col-6">
                <a class="btn btn-primary w-55 my-3" href="<?php echo e(route('paymentverification',$f->rrr)); ?>"  style="color: white">Verify Payment</a>
                </div>
                <div class="col-6">
                <form method="post" action="<?php echo e(config('remita.GATEWAYRRRPAYMENTURL')); ?>">
                  <input id="merchantId" name="merchantId" value="<?php echo e(config('remita.MERCHANTID')); ?>" type="hidden"/>
                  <input id="rrr" name="rrr" value="<?php echo e($f->rrr); ?>" type="hidden"/>
                  <input id="responseurl" name="responseurl" value="<?php echo e(url('/verify/student/payment/'.$f->rrr)); ?>" type="hidden"/>
                  <input id="hash" name="hash" value="<?php echo e($hash); ?>" type="hidden"/>

                  <button type="submit" class="btn btn-warning w-55 my-3"  style="color: white">Pay Online</button>
                </form>
                </div>
                </div>
              </td>
            <?php else: ?>
              <td>
                <span class="badge bg-label-success me-1"> Paid</span>
              </td>
              <td></td>

            <?php endif; ?>






          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>
  <!--/ Bootstrap Table with Header Dark -->


<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\portal\resources\views/fees/payment_rrr.blade.php ENDPATH**/ ?>