<?php $__env->startSection('title', 'Result Upload'); ?>

<?php $__env->startSection('vendor-style'); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/dropzone/dropzone.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/select2/select2.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/bootstrap-select/bootstrap-select.css')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
  <script src="<?php echo e(asset('assets/vendor/libs/dropzone/dropzone.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/select2/select2.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/bootstrap-select/bootstrap-select.js')); ?>"></script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
  <script src="<?php echo e(asset('assets/js/forms-selects.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/js/forms-file-upload.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


  <div class="row">
    <!-- Basic  -->
    <div class="col-12">
      <div class="card mb-4">
        <h5 class="card-header">Result Upload</h5>
        <?php if(session()->has('errors')): ?>
          <div class="alert alert-danger alert-dismissible d-flex align-items-center" role="alert">
            <?php echo e(session('errors')->first()); ?>


            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
            </button>
          </div>
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
          <div class="alert alert-warning alert-dismissible d-flex align-items-center" role="alert">
            <?php echo e(session()->get('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
            </button>
          </div>
        <?php endif; ?>
        <div class="card-body">
          <form action="<?php echo e(route('admin.uploadresult')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="row g-2">

              <div class="col-md-6 ">
                <label class="form-label" for="multicol-course">Course</label>
                <select id="multicol-course" name="course" class="select2 form-select form-select-lg" data-allow-clear="true">
                  <?php $__currentLoopData = $course; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($c->id); ?>">[<?php echo e($c->code); ?>]  <?php echo e($c->name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
              <div class="col-md-6 ">
                <label class="form-label" for="basic-default-fullname">Select Session</label>

                <select  class="select2 form-select"  data-allow-clear="true" name="year">
                  <?php $__currentLoopData = $periods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($p->c_year); ?>"><?php echo e($p->c_session); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
              <div class="col-md-6">
                <label class="form-label" for="basic-default-fullname">Select Semester</label>
                <select  class="select2 form-select" data-allow-clear="true" name="sem">
                  <?php $__currentLoopData = $semesters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($pp->id); ?>"><?php echo e($pp->name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
              <div class="col-md-6 ">
                <label class="form-label" for="resultfile">Result File</label>
                <input class="form-control" name="result" type="file" accept=".csv,.xlsx" />
              </div>
              <div class="col-md-6 ">
                <label class="form-label" for="basic-default-fullname">.</label>
                <button type="submit" class="btn btn-primary">Upload Result</button>
              </div>
              <div class="col-md-6 ">
                <label class="form-label" for="basic-default-fullname">.</label>
                <a href="<?php echo e(url('admin/download/result/template')); ?>"> <button type="button" class="btn btn-success">Download Template</button></a>
              </div>

            </div>

          </form>
        </div>
      </div>
    </div>
    <!-- /Basic  -->

  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin/layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\portal\resources\views/admin/result/upload-result.blade.php ENDPATH**/ ?>