<?php $__env->startSection('title', 'Student Semester Result'); ?>

<?php $__env->startSection('vendor-style'); ?>

  <link href="https://cdn.datatables.net/v/bs5/jszip-3.10.1/dt-2.3.4/b-3.2.5/b-html5-3.2.5/b-print-3.2.5/cr-2.1.1/cc-1.1.0/date-1.6.0/fc-5.0.5/fh-4.0.4/kt-2.12.1/r-3.0.7/rg-1.6.0/rr-1.5.0/sc-2.4.3/sb-1.8.4/sp-2.3.5/sl-3.1.2/datatables.min.css" rel="stylesheet" integrity="sha384-sJUMfrejiv5pRmY5qNGZVl4JMtWiZ53QA1/6/7GLLBQdxCJMhOwunSFrcJT3Xlkk" crossorigin="anonymous">

<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-script'); ?>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js" integrity="sha384-VFQrHzqBh5qiJIU0uGU5CIW3+OWpdGGJM9LBnGbuIH2mkICcFZ7lPd/AAtI7SNf7" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js" integrity="sha384-/RlQG9uf0M2vcTw3CX7fbqgbj/h8wKxw7C3zu9/GxcBPRKOEcESxaxufwRXqzq6n" crossorigin="anonymous"></script>
  <script src="https://cdn.datatables.net/v/bs5/jszip-3.10.1/dt-2.3.4/b-3.2.5/b-html5-3.2.5/b-print-3.2.5/cr-2.1.1/cc-1.1.0/date-1.6.0/fc-5.0.5/fh-4.0.4/kt-2.12.1/r-3.0.7/rg-1.6.0/rr-1.5.0/sc-2.4.3/sb-1.8.4/sp-2.3.5/sl-3.1.2/datatables.min.js" integrity="sha384-l1GvbIu8PJBS6ck4sP/OSRP0QQcdFEUl82+8qUHmKwkrMllwjkkT2e9gNfIyuSxW" crossorigin="anonymous"></script>
  <script >

    new DataTable('#reslt', {
      layout: {
        topStart: {
          buttons: [
            'copy', 'print', 'pdf'
          ]
        }
      },
      columnDefs: [{
        "defaultContent": "-",
        "targets": "_all"
      }]
    });
  </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <h4 class="py-3 breadcrumb-wrapper mb-4">

  </h4>


  <!-- Result List Table -->
  <div class="card">
    <div class="card-header" style="margin: auto"> Rows in Red Contain invalid Student Registration Number Please correct them before uploading again.</div>

    <div class="card-datatable table-responsive">
      <table class="table" id="reslt">
        <thead>
        <tr>

          <th>S/N</th>
          <th>Student</th>
          <th>Course Code</th>
          <th>Course Name</th>
          <th>CA</th>
          <th>Exam</th>
          <th>Total Score</th>
          <th>Grade</th>
          <th>Admin</th>
        </tr>
        </thead>
        <tbody>

          <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resultt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr <?php if(\App\Models\DummyResult::checkNumb($resultt->student_reg)==false): ?>style="background-color: red" <?php endif; ?>>
              <td><?php echo e($loop->iteration); ?></td>
              <td><?php echo e($resultt->student_reg); ?></td>
              <td><?php echo e($resultt->dummyresultcourse->code); ?></td>
              <td><?php echo e($resultt->dummyresultcourse->name); ?></td>
              <td><?php echo e($resultt->ca_score); ?></td>
              <td><?php echo e($resultt->exam_score); ?></td>
              <td><?php echo e($resultt->total_score); ?></td>
              <td><?php echo e($resultt->grade); ?></td>
              <td><?php echo e($resultt->dummyresultadmin->name); ?></td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


        </tbody>
      </table>
    </div>
  </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\portal\resources\views/admin/result/verify-upload.blade.php ENDPATH**/ ?>