<?php
  $customizerHidden = 'customizer-hide';
?>



<?php $__env->startSection('title', 'Admin Login'); ?>

<?php $__env->startSection('vendor-style'); ?>
  <!-- Vendor -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/@form-validation/umd/styles/index.min.css')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
  <!-- Page -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/pages/page-auth.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
  <script src="<?php echo e(asset('assets/vendor/libs/@form-validation/umd/bundle/popular.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/@form-validation/umd/plugin-bootstrap5/index.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/@form-validation/umd/plugin-auto-focus/index.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
  <script src="<?php echo e(asset('assets/js/pages-auth.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <div class="container-xxl">
    <div class="authentication-wrapper authentication-basic container-p-y">
      <div class="authentication-inner py-4">

        <!-- Register -->
        <div class="card">
          <div class="card-body">
            <!-- Logo -->
            <div class="app-brand justify-content-center">
              <a href="<?php echo e(url('/admin/login')); ?>" class="app-brand-link gap-2">
                <span class="app-brand-logo demo"><?php echo $__env->make('_partials.macros', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?></span>
                <span class="app-brand-text demo h3 mb-0 fw-bold"><?php echo e(config('variables.templateName')); ?> Admin</span>
              </a>
            </div>
            <!-- /Logo -->

            <p class="mb-4">Enter you email below we will send you a link for you password reset</p>
            <?php if(session()->has('errors')): ?>
              <div class="alert alert-danger alert-dismissible d-flex align-items-center" role="alert">
                <?php echo e(session('errors')->first()); ?>


                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                </button>
              </div>
            <?php endif; ?>
            <?php if(session()->has('error')): ?>
              <div class="alert alert-warning alert-dismissible d-flex align-items-center" role="alert">
                <?php echo e(session()->get('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                </button>
              </div>
            <?php endif; ?>
            <form id="formAuthentication" class="mb-3" action="<?php echo e(route('admin.password.update')); ?>" method="post">
              <?php echo csrf_field(); ?>
              <input type="hidden" name="token" value="<?php echo e($request); ?>">
              <div class="mb-3">
                <label for="email" class="form-label">Email</label>
                <input type="text" class="form-control" id="email" name="email" placeholder="Enter your email" autofocus>
              </div>
              <div class="mb-3 form-password-toggle">
                <label class="form-label" for="password">New Password</label>
                <div class="input-group input-group-merge">
                  <input type="password" id="password" class="form-control" name="password" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password" />
                  <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                </div>
              </div>
              <div class="mb-3 form-password-toggle">
                <label class="form-label" for="confirm-password">Confirm Password</label>
                <div class="input-group input-group-merge">
                  <input type="password" id="confirm-password" class="form-control" name="password_confirmation" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password" />
                  <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                </div>
              </div>
              <button type="submit" class="btn btn-primary d-grid w-100 mb-3">
                Set new password
              </button>
              <div class="text-center">
                <a href="<?php echo e(route('admin.login')); ?>">
                  <i class="bx bx-chevron-left scaleX-n1-rtl"></i>
                  Back to login
                </a>
              </div>


              <button class="btn btn-primary d-grid w-100">
                Reset Password
              </button>
            </form>



          </div>
        </div>
        <!-- /Register -->
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\portal\resources\views/admin/auth/auth-reset-password.blade.php ENDPATH**/ ?>