@extends('layouts/layoutMaster')

@section('title', 'Load Courses')

@section('vendor-style')
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/select2/select2.css')}}" />
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/tagify/tagify.css')}}" />
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/bootstrap-select/bootstrap-select.css')}}" />
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/typeahead-js/typeahead.css')}}" />
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/multiselect/css/multi-select.css')}}" />
@endsection

@section('vendor-script')
  <script src="{{asset('assets/vendor/libs/select2/select2.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/tagify/tagify.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/bootstrap-select/bootstrap-select.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/typeahead-js/typeahead.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/bloodhound/bloodhound.js')}}"></script>


  <script src="{{asset('assets/vendor/libs/multiselect/js/jquery.multi-select.js')}}"></script>

  <script>
    $('#custom-headers').multiSelect({
      keepOrder: true,
      selectableHeader: "<div class='custom-header SelectorHeader'>Courses <span id='ldb' style='text-align:right; color:rgba(0,255,0,1); float:right; margin-right:30px; font-weight:600'> 0 </span> </div>",
      selectionHeader: "<div class='custom-header SelectorHeader'>Added Courses <span id='ldd' style='text-align:right; color:rgba(0,255,0,1); float:right; margin-right:30px;font-weight:600'> 0 </span></div>"
    });

    var ftl=$("#cload").val();
    $(".custom-header #ldb").html('Loadeable Unit '+ftl);


    $("#custom-headers").change(function(e) {
      var tl=$("#cload").val();
      var ass=0;
      var cc=$("#custom-headers").val();
      $(cc).each(function(df) {
        var dd=cc[df].split('/');
        ass +=parseInt(dd[1]);

        var ltl=tl-ass

        if(ass<=tl){
          $(".custom-header #ldb").html('Loadable Unit =>'+ltl);
          $(".custom-header #ldd").html('Loaded=>'+ass);
          $("#error").hide();
        }else{
          var test=$('#custom-headers :selected').last().val()

          $('#custom-headers').multiSelect('deselect', test);
          $("#error").html('you can not exceed your total loadable unit');
          $("#error").show();
          //alert('you can not exceed your total loadable unit');
        }
      });


    });




    var tl2=$("#cload").val();
    var ass2=0;
    var cc2=$("#custom-headers").val();
    $(cc2).each(function(df) {
      var dd=cc2[df].split('/');
      ass2 +=parseInt(dd[1]);
      var ltl2=tl2-ass2
      if(ass2<=tl2){
        $(".custom-header #ldb").html('Loadable Unit =>'+ltl2);
        $(".custom-header #ldd").html('Loaded=>'+ass2);
        $("#error").hide();
      }else{
        var test2=$('#custom-headers :selected').last().val()
        $('#custom-headers').multiSelect('deselect', test2);
        $("#error").html('you can not exceed your total loadable unit: it seems your carryovers are more than your allowable unit please contact the portal office');
        $("#error").show();
        //alert('you can not exceed your total loadable unit: it seems your carryovers are more than your allowable unit please contact the portal office');

      }


    });

  </script>
@endsection

@section('page-script')
  <script src="{{asset('assets/js/forms-selects.js')}}"></script>
  <script src="{{asset('assets/js/forms-tagify.js')}}"></script>
  <script src="{{asset('assets/js/forms-typeahead.js')}}"></script>
@endsection

@section('content')
  <h4 class="py-3 breadcrumb-wrapper mb-4">
    <span class="text-muted fw-light">Add / Carry/ Over</span>
  </h4>

  <div class="row">


    <div class="col-12">
      <div class="card mb-4">
        <h5 class="card-header">
          @if(session()->has('errors'))
            <div class="alert alert-warning alert-dismissible d-flex align-items-center" role="alert">
              {{session('errors')->first() }}

              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              </button>
            </div>
          @endif
          @if(session()->has('error'))
            <div class="alert alert-warning alert-dismissible d-flex align-items-center" role="alert">
              {{session()->get('error')}}
              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              </button>
            </div>
          @endif
        </h5>
        <div class="card-body">
          <div class="row">


            <div class="col-md-12 ">

              <form action="{{route('loadcourses')}}" method="post">
                @csrf
                <table width="100%" border="0">
                  <tr>
                    <td height="44" colspan="2">
                      <select name="cuss[]" multiple="multiple" id="custom-headers" >
                        @foreach($course2 as $c)
                          <option id="{{$c->id}}" style="color: red;" @isset($stdlvl) {{\App\Models\LoadedCourses::checkloaded($c->id,$user->id,$semester->id,$stdlvl) }}@else {{\App\Models\LoadedCourses::checkloaded($c->id,$user->id,$semester->id,$user->s_level) }} @endisset value='{{$c->id}}/{{$c->credit_unit}}'>({{strtoupper($c->code)}}) {{strtoupper($c->name)}} (UNIT {{strtoupper($c->credit_unit)}})</option>
                        @endforeach
                        @foreach($course as $c)
                          <option id="{{$c->id}}" @isset($stdlvl) {{\App\Models\LoadedCourses::checkloaded($c->id,$user->id,$semester->id,$stdlvl) }}@else {{\App\Models\LoadedCourses::checkloaded($c->id,$user->id,$semester->id,$user->s_level) }} @endisset value='{{$c->id}}/{{$c->credit_unit}}'>({{strtoupper($c->code)}}) {{strtoupper($c->name)}} (UNIT {{strtoupper($c->credit_unit)}})</option>
                        @endforeach

                      </select>
                      <input name="minload" id="mcload" type="hidden" value="{{$deptSettings->min_unit_load}}"/>
                      <input name="maxload" id="cload" type="hidden" value="{{$deptSettings->max_unit_load}}" />
                      <input name="semes" id="semes" type="hidden" value="{{$semester->id}}" />
                      <input name="usid" id="usid" type="hidden" value="{{$user->id}}" />
                      <input name="slvl" id="slvl" type="hidden" value="@isset($stdlvl){{$stdlvl}}@else{{$user->s_level}}@endisset" />
                      <input name="peri" id="peri" type="hidden" value="{{$period->c_session}}" />


                    </td>
                  </tr>
                  <tr>
                    <td width="20%">&nbsp;</td>
                    <td width="29%" height="50">
                      <input type="submit" name="go" id="go" value="Load Course" class="btn btn-primary active"/></td>
                  </tr>
                </table>
              </form>

            </div>
          </div>
        </div>
      </div>
    </div>



  </div>
@endsection
