@extends('layouts/layoutMaster')

@section('title', 'Preview - Course Form')

@section('vendor-style')
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/flatpickr/flatpickr.css')}}" />
@endsection

@section('page-style')
  <link rel="stylesheet" href="{{asset('assets/vendor/css/pages/app-invoice.css')}}" />
@endsection



@section('vendor-script')
  <script src="{{asset('assets/vendor/libs/moment/moment.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/flatpickr/flatpickr.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/cleavejs/cleave.js')}}"></script>
@endsection

@section('content')

  <div class="row invoice-preview">
    <!-- Invoice -->
    <div class="col-xl-9 col-md-8 col-12 mb-md-0 mb-4">
      <div class="card invoice-preview-card">
        <div class="card-header">
          @if(session()->has('error'))
            <div class="alert alert-info alert-dismissible d-flex align-items-center" role="alert">
              {{session()->get('error')}}
              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              </button>
            </div>
          @endif
        </div>
        <div class="card-body">
          <div class="row p-sm-3 p-0">

            <div class="col-xl-12 col-md-12 col-sm-12 col-12">
              <h6 class="pb-2">Course registration summary:</h6>
              <table>
                <tbody>
                <tr>
                  <td class="pe-3">Number Of Courses:</td>
                  <td class="fw-medium">{{count($cusfom->loadedcourses)}}</td>
                </tr>
                <tr>
                  <td class="pe-3">Session:</td>
                  <td>{{$cusfom->session}}</td>
                </tr>
                <tr>
                  <td class="pe-3">Semester:</td>
                  <td>@if($cusfom->semester==1) First Semester @else Second Semester @endif</td>
                </tr>
                <tr>
                  <td class="pe-3">Level:</td>
                  <td>{{$cusfom->student_level}}00 Level</td>
                </tr>
                <tr>
                  <td class="pe-3">Total Credit Unit:</td>
                  <td>{{$cusfom->loadedcourses->sum('course_load')}}</td>
                </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>
        <div class="table-responsive">
          <table class="table border-top m-0">
            <thead>
            <tr>
              <th>S/n</th>
              <th>Course Code</th>
              <th>Course Name</th>
              <th>Credit Unit</th>

            </tr>
            </thead>
            <tbody>
            @foreach($cusfom->loadedcourses as $cs)
            <tr>
              <td >{{$loop->iteration}}</td>
              <td>{{$cs->course->code}}</td>
              <td class="text-nowrap">{{$cs->course->name}}</td>
              <td>{{$cs->course->credit_unit}}</td>

            </tr>
            @endforeach
            </tbody>
          </table>
        </div>

        <div class="card-body">
          <div class="row">
            <div class="col-12">
              <span class="fw-medium">Note:</span>
              <span>Please verify your courses before you print. Once you print it you will not be able to edit it on your own again . Thank You!</span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- /Invoice -->

    <!-- Invoice Actions -->
    <div class="col-xl-3 col-md-4 col-12 invoice-actions">
      <div class="card">

        <div class="card-body">

{{--          <button class="btn btn-label-info d-grid w-100 mb-3">--}}
{{--            Download--}}
{{--          </button>--}}
          <a class="btn btn-label-danger d-grid w-100 mb-3" target="_blank" href="{{route('course.form.print',$cid)}}">
            Print
          </a>
          <a href="{{route("load-course-form",$cid)}}" class="btn btn-label-primary d-grid w-100 mb-3">
            Edit Course Form
          </a>
          <a href="{{route("load-carry-over",$cid)}}" class="btn btn-label-success d-grid w-100 mb-3">
            Add Carry Over
          </a>

        </div>
      </div>
    </div>
    <!-- /Invoice Actions -->
  </div>

@endsection
