@extends('layouts/layoutMaster')

@section('title', 'Student Semester Result')

@section('vendor-style')

  <link href="https://cdn.datatables.net/v/bs5/jszip-3.10.1/dt-2.3.4/b-3.2.5/b-html5-3.2.5/b-print-3.2.5/cr-2.1.1/cc-1.1.0/date-1.6.0/fc-5.0.5/fh-4.0.4/kt-2.12.1/r-3.0.7/rg-1.6.0/rr-1.5.0/sc-2.4.3/sb-1.8.4/sp-2.3.5/sl-3.1.2/datatables.min.css" rel="stylesheet" integrity="sha384-sJUMfrejiv5pRmY5qNGZVl4JMtWiZ53QA1/6/7GLLBQdxCJMhOwunSFrcJT3Xlkk" crossorigin="anonymous">

@endsection


@section('page-script')

  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js" integrity="sha384-VFQrHzqBh5qiJIU0uGU5CIW3+OWpdGGJM9LBnGbuIH2mkICcFZ7lPd/AAtI7SNf7" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js" integrity="sha384-/RlQG9uf0M2vcTw3CX7fbqgbj/h8wKxw7C3zu9/GxcBPRKOEcESxaxufwRXqzq6n" crossorigin="anonymous"></script>
  <script src="https://cdn.datatables.net/v/bs5/jszip-3.10.1/dt-2.3.4/b-3.2.5/b-html5-3.2.5/b-print-3.2.5/cr-2.1.1/cc-1.1.0/date-1.6.0/fc-5.0.5/fh-4.0.4/kt-2.12.1/r-3.0.7/rg-1.6.0/rr-1.5.0/sc-2.4.3/sb-1.8.4/sp-2.3.5/sl-3.1.2/datatables.min.js" integrity="sha384-l1GvbIu8PJBS6ck4sP/OSRP0QQcdFEUl82+8qUHmKwkrMllwjkkT2e9gNfIyuSxW" crossorigin="anonymous"></script>
  <script >

    new DataTable('#reslt', {
     columnDefs: [{
        "defaultContent": "-",
        "targets": "_all"
      }]
    });
  </script>
@endsection

@section('content')
  <h4 class="py-3 breadcrumb-wrapper mb-4">
    <span class="text-muted fw-light">Student /</span>{{$period->c_year}} {{$semester->name}} Result
  </h4>
  <div class="accordion mb-4" id="collapsibleSection">
    <div class="card accordion-item">
      <h2 class="accordion-header" id="headingDeliveryAddress">
        <button type="button" class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseDeliveryAddress" aria-expanded="true" aria-controls="collapseDeliveryAddress">
          Change Result </button>
      </h2>
      <div id="collapseDeliveryAddress" class="accordion-collapse collapse show" data-bs-parent="#collapsibleSection">
        <div class="accordion-body">
          <div class="row g-3">
            <div class="card ">


              <div class="card-body">
                <form class="w-px-500 border rounded p-3 p-md-8" method="post" action="{{route('viewResult')}}">
                  @csrf
                  <div class="mb-3">
                    <label class="form-label" for="basic-default-fullname">Select Session</label>

                    <select  class="select2 form-select" data-allow-clear="true" name="sess">
                      @foreach($allperiods as $p)
                        <option value="{{$p->c_year}}">{{$p->c_session}}</option>
                      @endforeach
                    </select>
                  </div>
                  <div class="mb-3">
                    <label class="form-label" for="basic-default-fullname">Select Semester</label>
                    <select  class="select2 form-select" data-allow-clear="true" name="sem">
                      @foreach($allsemesters as $pp)
                        <option value="{{$pp->id}}">{{$pp->name}}</option>
                      @endforeach
                    </select>
                  </div>

                  <button type="submit" class="btn btn-primary">Get Result</button>
                </form>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
    </div>





  <!-- Result List Table -->
  <div class="card">

    <div class="card-header header-elements">
      <span class=" me-2"></span>

      <div class="card-header-elements ms-auto">
        @if($cusfom!=null)  <a class="btn btn-label-primary d-grid w-100 mb-3" target="_blank" href="{{route('result.print',$cusfom->id)}}">
          Print Result
        </a>@endif
      </div>
    </div>
    <div class="card-datatable table-responsive">
      <table class="table" id="reslt">
        <thead>
        <tr>

          <th>S/N</th>
          <th>Course Code</th>
          <th>Course Name</th>
          <th>CA</th>
          <th>Exam</th>
          <th>Total Score</th>
          <th>Grade</th>
        </tr>
        </thead>
        <tbody>
        @if($cusfom!=null)

          @foreach($cusfom->loadedcourses as $cf)
            @php
            $result=\App\Models\Result::getSingleResult($cf->course_id,$cf->student_id,$semester->id,$period->c_session);
            @endphp
        <tr>
        <td>{{$loop->iteration}}</td>
        <td>{{$cf->course->code}}</td>
        <td>{{$cf->course->name}}</td>
        <td>@if($result==null)No Result Yet @else {{$result->ca_score}}@endif</td>
        <td>@if($result==null)No Result Yet @else {{$result->exam_score}}@endif</td>
        <td>@if($result==null)No Result Yet @else {{$result->total_score}}@endif</td>
        <td>@if($result==null)No Result Yet @else {{$result->grade}}@endif</td>
        </tr>
          @endforeach
        @else
        <tr>
          <td></td>
          <td></td>
          <td>You did not load any course for {{$semester->name}} {{$period->c_year}} .</td>

        </tr>
        @endif

        </tbody>
      </table>
    </div>
  </div>

@endsection

