/* ================= SLIDER SCRIPT (LOCKED — UNTOUCHED) ================= */
document.addEventListener("DOMContentLoaded",()=>{
  const carouselEl=document.getElementById("campusSlider");
  const carouselInstance=new bootstrap.Carousel(carouselEl);

  function loadBg(slide){
    if(slide.classList.contains("bg-loaded")) return;
    const img=new Image();
    img.src=slide.dataset.bg;
    img.onload=()=>{
      slide.style.backgroundImage=`url('${slide.dataset.bg}')`;
      slide.classList.add("bg-loaded");
    };
  }
  function animateBullets(slide){
    slide.querySelectorAll("li").forEach((li,i)=>{
      li.style.transitionDelay=`${i*.25}s`;
      li.style.opacity=1;
      li.style.transform="none";
    });
  }
  function resetBullets(slide){
    slide.querySelectorAll("li").forEach(li=>{
      li.style.opacity=0;
      li.style.transform="translateY(12px)";
      li.style.transitionDelay="0s";
    });
  }

  const active=carouselEl.querySelector(".carousel-item.active");
  loadBg(active);
  animateBullets(active);

  carouselEl.addEventListener("slide.bs.carousel",e=>{
    loadBg(e.relatedTarget);
    resetBullets(e.relatedTarget);
  });
  carouselEl.addEventListener("slid.bs.carousel",e=>{
    animateBullets(e.relatedTarget);
  });

  setTimeout(()=>loginBox.classList.add("show"),150);
});

/* ================= MOBILE NAV + ACCESSIBILITY ================= */
const navToggle=document.getElementById("navToggle");
const navMenu=document.getElementById("navMenu");
const navOverlay=document.getElementById("navOverlay");
const navLinks=[...navMenu.querySelectorAll("a")];
let scrollY=0,startX=0,startT=0;

function lockScroll(){
  scrollY=window.scrollY;
  document.body.style.position="fixed";
  document.body.style.top=`-${scrollY}px`;
}
function unlockScroll(){
  document.body.style.position="";
  document.body.style.top="";
  window.scrollTo(0,scrollY);
}
function openNav(){
  lockScroll();
  navToggle.classList.add("active");
  navMenu.classList.add("active");
  navOverlay.classList.add("active");
  navToggle.setAttribute("aria-expanded","true");
  navMenu.setAttribute("aria-hidden","false");
  navLinks[0].focus();
}
function closeNav(){
  unlockScroll();
  navToggle.classList.remove("active");
  navMenu.classList.remove("active");
  navOverlay.classList.remove("active");
  navToggle.setAttribute("aria-expanded","false");
  navMenu.setAttribute("aria-hidden","true");
  navToggle.focus();
}

navToggle.onclick=()=>navMenu.classList.contains("active")?closeNav():openNav();
navOverlay.onclick=closeNav;

document.addEventListener("keydown",e=>{
  if(e.key==="Escape") closeNav();
  if(navMenu.classList.contains("active") && e.key==="Tab"){
    const first=navLinks[0];
    const last=navLinks[navLinks.length-1];
    if(e.shiftKey && document.activeElement===first){
      e.preventDefault();last.focus();
    }else if(!e.shiftKey && document.activeElement===last){
      e.preventDefault();first.focus();
    }
  }
});

/* Swipe close */
navMenu.addEventListener("touchstart",e=>{
  startX=e.touches[0].clientX;
  startT=Date.now();
});
navMenu.addEventListener("touchend",e=>{
  const dx=startX-e.changedTouches[0].clientX;
  const dt=Date.now()-startT;
  if(dx>80 && dx/dt>0.35) closeNav();
});

/* Resize hardening */
window.addEventListener("resize",()=>{
  if(window.innerWidth>991) closeNav();
});

/* ================= DARK MODE (PERSIST) ================= */
const themeBtn=document.getElementById("themeToggle");
if(localStorage.theme==="dark"){
  document.body.classList.add("dark");
  themeBtn.innerHTML='<i class="bi bi-sun"></i>';
}
themeBtn.onclick=()=>{
  document.body.classList.toggle("dark");
  localStorage.theme=document.body.classList.contains("dark")?"dark":"light";
  themeBtn.innerHTML=document.body.classList.contains("dark")
    ?'<i class="bi bi-sun"></i>'
    :'<i class="bi bi-moon"></i>';
};
/* ================= PASSWORD ================= */
togglePass.onclick=()=>{
  password.type=password.type==="password"?"text":"password";
  togglePass.classList.toggle("bi bi-eye-slash");
};

// $(".toggle-pwd").click(function(){$(this).toggleClass("fa-eye fa-eye-slash");var input=$($(this).attr("toggle"));if(input.attr("type")==="password"){input.attr("type","text");}else{input.attr("type", "password");}});

password.addEventListener("keyup",e=>{
  capsWarn.style.display=e.getModifierState("CapsLock")?"block":"none";
});

setTimeout(function() {
  const alertNode = document.querySelector('.alert');
  if(alertNode) {
    const alert = new bootstrap.Alert(alertNode);
    alert.close();
  }
}, 10000); // closes after 10 seconds