<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Student Portal Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<!-- SEO META TAG -->
<meta name="title" content="Nwafor Orizu College of Education, Nsugbe">
<meta name="description" content="Nwafor Orizu College of Education is a leading institution offering Bachelor of Education, Nigerian Certificate in Education, Professional Diploma in Education, and research programs focused on academic excellence, innovation, and global impact.">
<meta name="keywords" content="Nocen, Nsugbe, higher education, college admissions, degree programs, NCE, Part Time, PDE, Sandwich, postgraduate studies, research college, academic excellence">
<meta name="language" content="English">
<meta name="distribution" content="global">
<meta name="author" content="Consolidated Furtune Ltd">
<meta name="robots" content="index, follow">
<!-- Open Graph (Facebook, WhatsApp, LinkedIn) -->
<meta property="og:type" content="website">
<meta property="og:title" content="Nwafor Orizu College of Education">
<meta property="og:description" content="Empowering future educators through quality teaching, learning, and research at Nwafor Orizu College of Education.">
<meta property="og:url" content="https://www.siennatransport.com">
<meta property="og:image" content="https://www.siennatransport.com/assets/preview.jpg">
<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Nwafor Orizu College of Education">
<meta name="twitter:description" content="Empowering future educators through quality teaching, learning, and research at Nwafor Orizu College of Education.">
<meta name="twitter:image" content="https://www.siennatransport.com/assets/preview.jpg">
<!-- Mobile & Theme Color (Nice UX touch) -->
<meta name="theme-color" content="#8B4513">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black">
<!-- Security & Browser Behavior -->
<meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
<meta http-equiv="Referrer-Policy" content="strict-origin-when-cross-origin">
<link rel="canonical" href="https://www.siennatransport.com/seat-reservation">
<!-- Performance Optimization -->
<meta http-equiv="Cache-Control" content="public, max-age=31536000">
<meta http-equiv="Expires" content="31536000">
<!-- Progressive Web App -->
<meta name="mobile-web-app-capable" content="yes">
<meta name="application-name" content="NOCEN">
<meta name="apple-mobile-web-app-title" content="Nwafor Orizu College of Education">
<meta name="apple-touch-fullscreen" content="yes">
<!-- Favicons -->
<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
<link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
<!--  -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="auth-style.css">
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Institution",
  "name": "Nwafor Orizu College of Education",
  "url": "https://www.siennatransport.com",
  "logo": "https://www.siennatransport.com/assets/logo.png",
  "description": "Empowering future educators through quality teaching, learning, and research at Nwafor Orizu College of Education.",
  "areaServed": "Nigeria",
  "sameAs": [
    "https://facebook.com/siennatransport",
    "https://instagram.com/siennatransport"
  ]
}
</script>
</head>
<body>
<!-- MOBILE NAV -->
<div class="mobile-nav" title="Nocen Program">
<button class="nav-toggle" id="navToggle" 
        aria-expanded="false"
        aria-controls="navMenu"
        aria-label="Toggle navigation">
    <i class="bi bi-list"></i>
    <i class="bi bi-x"></i>
</button>
</div>

<div class="nav-overlay" id="navOverlay"></div>

  <nav class="nav-menu" id="navMenu" aria-hidden="true">
    <h4>Available Program</h4>
    <a href="#">Degree Program</a>
    <a href="#">NCE Program</a>
    <a href="#">Part Time Program</a>
    <a href="#">Sandwich Program</a>
    <a href="#">PDE Program</a>
    <!-- <a href="#">ICT Support</a> -->
  </nav>

<!-- DARK MODE -->
<div class="theme-toggle">
<button class="theme-btn" id="themeToggle">
    <i class="bi bi-moon"></i>
</button>
</div>

<div class="container-fluid">
<div class="row min-vh-100">

<!-- ================= SLIDER (FULL — RESTORED) ================= -->
<div class="col-lg-7 d-none d-lg-block slider-section p-0">
<div id="campusSlider" class="carousel slide h-100" data-bs-ride="carousel" data-bs-interval="7000">

<div class="carousel-indicators">
    <button data-bs-target="#campusSlider" data-bs-slide-to="0" class="active"></button>
    <button data-bs-target="#campusSlider" data-bs-slide-to="1"></button>
    <button data-bs-target="#campusSlider" data-bs-slide-to="2"></button>
</div>

<div class="carousel-inner h-100">

<div class="carousel-item active lazy-bg" data-bg="https://images.unsplash.com/photo-1562774053-701939374585">
  <div class="carousel-overlay"></div>
    <div class="carousel-content">
      <h2 class="mb-0">Welcome to <br>Nwafor Orizu College of Education.</h2>
      <p class="">Please select your school program below to proceed to your portal.</p>
      <ul>
        <li><a href="#" class="btn btn-sm btn-primary mb-3" target="parent">DEGREE PROGRAM</a></li>
        <li><a href="#" class="btn btn-sm btn-primary mb-3" target="parent">NCE PROGRAM</a></li>
        <li><a href="#" class="btn btn-sm btn-primary mb-3" target="parent">PART TIME PROGRAM</a></li>
        <li><a href="#" class="btn btn-sm btn-primary mb-3" target="parent">SANDWICH PROGRAM</a></li>
        <li><a href="#" class="btn btn-sm btn-primary mb-3" target="parent">PDE PROGRAM</a></li>
      </ul>
    <p class="mt-4 fst-italic">Excellence in knowledge, virtue and service.</p>
    </div>
  </div>

  <div class="carousel-item lazy-bg" data-bg="https://images.unsplash.com/photo-1509062522246-3755977927d7">
    <div class="carousel-overlay"></div>
    <div class="carousel-content">
      <h2>Academic Excellence</h2>
      <ul style="list-style-type:">
        <li>Lecture materials</li>
        <li>School collaboration</li>
        <li>Smart campus services</li>
      </ul>
      <ul>
        <li><a href="#" class="btn btn-sm btn-success mb-3" target="parent">DEGREE PROGRAM</a></li>
        <li><a href="#" class="btn btn-sm btn-success mb-3" target="parent">NCE PROGRAM</a></li>
        <li><a href="#" class="btn btn-sm btn-success mb-3" target="parent">PART TIME PROGRAM</a></li>
        <li><a href="#" class="btn btn-sm btn-success mb-3" target="parent">SANDWICH PROGRAM</a></li>
        <li><a href="#" class="btn btn-sm btn-success mb-3" target="parent">PDE PROGRAM</a></li>
      </ul>
    </div>
  </div>

  <div class="carousel-item lazy-bg" data-bg="https://images.unsplash.com/photo-1509062522246-3755977927d7">
    <div class="carousel-overlay"></div>
    <div class="carousel-content">
      <h2>Connected Campus</h2>
      <ul>
        <li>Events & announcements</li>
        <li>Student dashboards</li>
        <li>24/7 access</li>
      </ul>
      <ul>
        <li><a href="#" class="btn btn-sm btn-info text-white mb-3" target="parent">DEGREE PROGRAM</a></li>
        <li><a href="#" class="btn btn-sm btn-info text-white mb-3" target="parent">NCE PROGRAM</a></li>
        <li><a href="#" class="btn btn-sm btn-info text-white mb-3" target="parent">PART TIME PROGRAM</a></li>
        <li><a href="#" class="btn btn-sm btn-info text-white mb-3" target="parent">SANDWICH PROGRAM</a></li>
        <li><a href="#" class="btn btn-sm btn-info text-white mb-3" target="parent">PDE PROGRAM</a></li>
      </ul>
    </div>
  </div>
</div>

<button class="carousel-control-prev" type="button" data-bs-target="#campusSlider" data-bs-slide="prev">
    <span class="carousel-control-prev-icon"></span>
</button>
<button class="carousel-control-next" type="button" data-bs-target="#campusSlider" data-bs-slide="next">
    <span class="carousel-control-next-icon"></span>
</button>

</div>
</div>

<!-- ================= LOGIN ================= -->
<div class="col-lg-5 login-section">
<div class="login-box" id="loginBox">

<div class="text-center mb-5 ">
    <div class="login-icon"><i class="bi bi-mortarboard"></i></div>
    <h4 class="mt-1">Student Login</h4>
    <p class="small fst-italic mt-0">Sign in to your <span class="fw-semibold">Degree Program</span> to continue.</p>
</div>

<div class="alert alert-danger alert-dismissible fade show" role="alert">
  Invalid login details. Please try again.
  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
<div class="alert alert-success alert-dismissible fade show" role="alert">
  You have successfully signed in to your Degree Program.
  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>

<form method="" action="" autocomplete="off" class="">
  <label>Email or Reg. No.</label>
  <input class="form-control mb-3" placeholder="Enter your email or Reg. No." name="emailOrRegNo">
  <div class="d-flex justify-content-between mb-1">
    <label>Password </label>
    <span></span>
    <a href="#" class="small forgot-link">Forgot password?</a>
  </div>

  <div class="password-wrap">
    <input type="password" id="password" name="password" class="form-control" placeholder="Enter password">
    <i class="bi bi-eye toggle-pass" id="togglePass"></i>
  </div>
  <div class="caps-warning small mt-1" id="capsWarn">Caps Lock is ON</div>

  <div class="form-check my-3">
    <input class="form-check-input" type="checkbox" id="remember">
    <label class="form-check-label" for="remember">Remember me</label>
  </div>

  <button class="btn btn-primary w-100 fw-semibold login-btn">Login</button>
  <div class="apply-link mt-2">
    Prospective student? <a href="#">Apply here</a>
  </div>
</form>

<!-- Forgotten Password  -->
<!-- Update Password -->
<footer>
  <span class="text-danger">©</span> 
  <?php echo date('Y'); ?> 
  Nwafor Orizu College of Education
</footer>
</div>
</div>
</div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script type="text/javascript" src="auth-script.js"></script>
</body>
</html>