<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>University Portal Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<style>
/* ================= ROOT ================= */
:root{
    --bg-login:#f8fafc;
    --card-bg:#ffffff;
    --text:#1f2937;
    --primary:#1e40af;
}
body.dark{
    --bg-login:#020617;
    --card-bg:#111827;
    --text:#e5e7eb;
    --primary:#3b82f6;
}
body{
    min-height:100vh;
    font-family:system-ui,sans-serif;
    background:var(--bg-login);
    color:var(--text);
}

/* ================= SLIDER (LOCKED — UNTOUCHED) ================= */
.slider-section{position:relative;overflow:hidden}
.carousel-item{
    min-height:100vh;
    background-size:cover;
    background-position:center;
    opacity:0;
    transition:opacity 1.2s ease-in-out;
}
.carousel-item.active{opacity:1}
.carousel-item.active.bg-loaded{
    animation:kenburns 18s ease-in-out infinite;
}
@keyframes kenburns{
    0%{transform:scale(1)}
    50%{transform:scale(1.08)}
    100%{transform:scale(1)}
}
.lazy-bg{opacity:0}
.lazy-bg.bg-loaded{opacity:1}

.carousel-overlay{
    position:absolute;
    inset:0;
    background:rgba(2,6,23,.65);
}
.carousel-content{
    position:relative;
    z-index:2;
    min-height:100vh;
    display:flex;
    flex-direction:column;
    justify-content:center;
    align-items:center;
    text-align:center;
    color:#fff;
    padding:3rem;
    opacity:0;
    transform:translateY(12px);
    transition:.8s ease;
}
.carousel-item.active .carousel-content{
    opacity:1;
    transform:none;
}
.carousel-content ul{list-style:none;padding:0}
.carousel-content li{
    font-size:1rem;
    font-weight:600;
    opacity:0;
    transform:translateY(12px);
    transition:.5s ease;
}

/* ================= LOGIN ================= */
.login-section{
    min-height:100vh;
    display:flex;
    align-items:center;
    justify-content:center;
}
.login-box{
    max-width:400px;
    width:100%;
    background:var(--card-bg);
    border-radius:14px;
    padding:2rem;
    opacity:0;
    transform:translateY(20px) scale(.96);
    transition:.7s cubic-bezier(.34,1.56,.64,1);
}
.login-box.show{opacity:1;transform:none}
.login-icon{font-size:2.4rem;color:var(--primary)}
.form-control{box-shadow:none!important}
.form-control:focus{border-color:var(--primary)}
.password-wrap{position:relative}
.toggle-pass{
    position:absolute;
    right:10px;
    top:50%;
    transform:translateY(-50%);
    cursor:pointer;
    color:#64748b;
    transition:.3s;
}
.toggle-pass:hover{color:var(--primary)}
.caps-warning{
    font-size:.8rem;
    color:#dc2626;
    display:none;
}
.login-btn:active{
    box-shadow:0 0 0 6px rgba(59,130,246,.25);
}
.apply-link{text-align:right;font-size:.9rem}
footer{text-align:center;font-size:.85rem;margin-top:1.5rem;color:#64748b}

/* ================= MOBILE NAV ================= */
.mobile-nav{
    position:fixed;
    top:0;
    left:0;
    z-index:1400;
    width:100%;
    padding:.75rem 1rem;
    display:none;
}
@media(max-width:991px){.mobile-nav{display:flex}}

.nav-toggle{
    font-size:1.8rem;
    background:none;
    border:none;
    color:var(--text);
    position:relative;
    z-index:1350; /* stays clickable */
}
.nav-toggle i{
    transition:.35s cubic-bezier(.34,1.56,.64,1);
}
.nav-toggle .bi-x{
    position:absolute;
    left:0;
    top:0;
    opacity:0;
    transform:rotate(-90deg) scale(.8);
}
.nav-toggle.active .bi-list{
    opacity:0;
    transform:rotate(90deg) scale(.8);
}
.nav-toggle.active .bi-x{
    opacity:1;
    transform:none;
}

/* Overlay */
/*.nav-overlay{*/
/*    position:fixed;*/
/*    inset:0;*/
/*    background:rgba(15,23,42,.55);*/
/*    backdrop-filter:blur(18px);*/
/*    -webkit-backdrop-filter:blur(18px);*/
/*    opacity:0;*/
/*    pointer-events:none;*/
/*    transition:.45s cubic-bezier(.22,1,.36,1);*/
/*    z-index:1300;*/
/*}*/


/* ================= GLASS OVERLAY (FIXED) ================= */
.nav-overlay::after{
    content:"";
    position:absolute;
    inset:0;
    pointer-events:none;

    /* subtle frosted noise */
    background-image:url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='200' height='200'%3E%3Cfilter id='n'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='.85' numOctaves='2' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23n)' opacity='.045'/%3E%3C/svg%3E");
}
.nav-overlay{
    position:fixed;
    inset:0;
    background:rgba(15,23,42,.55);
    backdrop-filter:blur(18px);
    -webkit-backdrop-filter:blur(18px);
    opacity:0;
    pointer-events:none;
    transition:.45s cubic-bezier(.22,1,.36,1);
    z-index:1250;
}

.nav-overlay.active{
    opacity:1;
    pointer-events:auto;
}

/* fallback */
@supports not ((backdrop-filter: blur(10px)) or (-webkit-backdrop-filter: blur(10px))) {
    .nav-overlay{
        background:rgba(15,23,42,0.8);
    }
}


/* Menu */
.nav-menu{
    position:fixed;
    inset:0;
    background:var(--card-bg);
    transform:translateX(-100%);
    transition:.55s cubic-bezier(.22,1,.36,1);
    padding:4.5rem 2rem;
    z-index:1300;
}
.nav-menu.active{transform:none}
.nav-menu a{
    display:block;
    font-size:1.25rem;
    padding:1rem 0;
    color:var(--text);
    text-decoration:none;
    opacity:0;
    transform:translateX(-24px);
    transition:
        opacity .45s cubic-bezier(.22,1,.36,1),
        transform .45s cubic-bezier(.22,1,.36,1);
}
.nav-menu.active a{opacity:1;transform:none}
.nav-menu.active a:nth-child(1){transition-delay:.1s}
.nav-menu.active a:nth-child(2){transition-delay:.18s}
.nav-menu.active a:nth-child(3){transition-delay:.26s}
.nav-menu.active a:nth-child(4){transition-delay:.34s}

/* ================= THEME ================= */
.theme-toggle{
    position:fixed;
    top:1rem;
    right:1rem;
    z-index:1500;
}
.theme-btn{
    width:44px;
    height:44px;
    border-radius:50%;
    border:1px solid var(--primary);
    background:var(--card-bg);
    color:var(--primary);
}
body.dark .theme-btn{
    color:#facc15;
    border-color:#facc15;
}
</style>
</head>

<body>

<!-- MOBILE NAV -->
<div class="mobile-nav">
<button class="nav-toggle" id="navToggle"
        aria-expanded="false"
        aria-controls="navMenu"
        aria-label="Toggle navigation">
    <i class="bi bi-list"></i>
    <i class="bi bi-x"></i>
</button>
</div>

<div class="nav-overlay" id="navOverlay"></div>

<nav class="nav-menu" id="navMenu" aria-hidden="true">
    <a href="#">Home</a>
    <a href="#">Admissions</a>
    <a href="#">Portal</a>
    <a href="#">Support</a>
</nav>

<!-- DARK MODE -->
<div class="theme-toggle">
<button class="theme-btn" id="themeToggle">
    <i class="bi bi-moon"></i>
</button>
</div>

<div class="container-fluid">
<div class="row min-vh-100">

<!-- ================= SLIDER (FULL — RESTORED) ================= -->
<div class="col-lg-7 d-none d-lg-block slider-section p-0">
<div id="campusSlider" class="carousel slide h-100" data-bs-ride="carousel" data-bs-interval="7000">

<div class="carousel-indicators">
    <button data-bs-target="#campusSlider" data-bs-slide-to="0" class="active"></button>
    <button data-bs-target="#campusSlider" data-bs-slide-to="1"></button>
    <button data-bs-target="#campusSlider" data-bs-slide-to="2"></button>
</div>

<div class="carousel-inner h-100">

<div class="carousel-item active lazy-bg" data-bg="https://images.unsplash.com/photo-1562774053-701939374585">
    <div class="carousel-overlay"></div>
    <div class="carousel-content">
        <h2>Welcome to University Portal</h2>
        <ul>
            <li>Course registration & results</li>
            <li>Academic announcements</li>
            <li>Secure student records</li>
        </ul>
    </div>
</div>

<div class="carousel-item lazy-bg" data-bg="https://images.unsplash.com/photo-1523050854058-8df90110c9f1">
    <div class="carousel-overlay"></div>
    <div class="carousel-content">
        <h2>Academic Excellence</h2>
        <ul>
            <li>Lecture materials</li>
            <li>Faculty collaboration</li>
            <li>Smart campus services</li>
        </ul>
    </div>
</div>

<div class="carousel-item lazy-bg" data-bg="https://images.unsplash.com/photo-1509062522246-3755977927d7">
    <div class="carousel-overlay"></div>
    <div class="carousel-content">
        <h2>Connected Campus</h2>
        <ul>
            <li>Events & announcements</li>
            <li>Student dashboards</li>
            <li>24/7 access</li>
        </ul>
    </div>
</div>

</div>

<button class="carousel-control-prev" type="button" data-bs-target="#campusSlider" data-bs-slide="prev">
    <span class="carousel-control-prev-icon"></span>
</button>
<button class="carousel-control-next" type="button" data-bs-target="#campusSlider" data-bs-slide="next">
    <span class="carousel-control-next-icon"></span>
</button>

</div>
</div>

<!-- ================= LOGIN ================= -->
<div class="col-lg-5 login-section">
<div class="login-box" id="loginBox">

<div class="text-center mb-3">
    <div class="login-icon"><i class="bi bi-mortarboard"></i></div>
    <h4 class="mt-2">University Login</h4>
</div>

<label>University ID</label>
<input class="form-control mb-3" placeholder="Enter your ID">

<label>Password</label>
<div class="d-flex justify-content-between mb-1">
    <span></span>
    <a href="#" class="small">Forgot password?</a>
</div>

<div class="password-wrap">
    <input type="password" id="password" class="form-control" placeholder="Enter password">
    <i class="bi bi-eye toggle-pass" id="togglePass"></i>
</div>
<div class="caps-warning" id="capsWarn">Caps Lock is ON</div>

<div class="form-check my-3">
    <input class="form-check-input" type="checkbox" id="remember">
    <label class="form-check-label" for="remember">Remember me</label>
</div>

<button class="btn btn-primary w-100 login-btn">Login</button>
<div class="apply-link mt-2"><a href="#">Apply here</a></div>

<footer>© 2026 University Portal</footer>
</div>
</div>

</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
/* ================= SLIDER SCRIPT (LOCKED — UNTOUCHED) ================= */
document.addEventListener("DOMContentLoaded",()=>{
    const carouselEl=document.getElementById("campusSlider");
    const carouselInstance=new bootstrap.Carousel(carouselEl);

    function loadBg(slide){
        if(slide.classList.contains("bg-loaded")) return;
        const img=new Image();
        img.src=slide.dataset.bg;
        img.onload=()=>{
            slide.style.backgroundImage=`url('${slide.dataset.bg}')`;
            slide.classList.add("bg-loaded");
        };
    }
    function animateBullets(slide){
        slide.querySelectorAll("li").forEach((li,i)=>{
            li.style.transitionDelay=`${i*.25}s`;
            li.style.opacity=1;
            li.style.transform="none";
        });
    }
    function resetBullets(slide){
        slide.querySelectorAll("li").forEach(li=>{
            li.style.opacity=0;
            li.style.transform="translateY(12px)";
            li.style.transitionDelay="0s";
        });
    }

    const active=carouselEl.querySelector(".carousel-item.active");
    loadBg(active);
    animateBullets(active);

    carouselEl.addEventListener("slide.bs.carousel",e=>{
        loadBg(e.relatedTarget);
        resetBullets(e.relatedTarget);
    });
    carouselEl.addEventListener("slid.bs.carousel",e=>{
        animateBullets(e.relatedTarget);
    });

    setTimeout(()=>loginBox.classList.add("show"),150);
});

/* ================= MOBILE NAV + ACCESSIBILITY ================= */
const navToggle=document.getElementById("navToggle");
const navMenu=document.getElementById("navMenu");
const navOverlay=document.getElementById("navOverlay");
const navLinks=[...navMenu.querySelectorAll("a")];
let scrollY=0,startX=0,startT=0;

function lockScroll(){
    scrollY=window.scrollY;
    document.body.style.position="fixed";
    document.body.style.top=`-${scrollY}px`;
}
function unlockScroll(){
    document.body.style.position="";
    document.body.style.top="";
    window.scrollTo(0,scrollY);
}
function openNav(){
    lockScroll();
    navToggle.classList.add("active");
    navMenu.classList.add("active");
    navOverlay.classList.add("active");
    navToggle.setAttribute("aria-expanded","true");
    navMenu.setAttribute("aria-hidden","false");
    navLinks[0].focus();
}
function closeNav(){
    unlockScroll();
    navToggle.classList.remove("active");
    navMenu.classList.remove("active");
    navOverlay.classList.remove("active");
    navToggle.setAttribute("aria-expanded","false");
    navMenu.setAttribute("aria-hidden","true");
    navToggle.focus();
}

navToggle.onclick=()=>navMenu.classList.contains("active")?closeNav():openNav();
navOverlay.onclick=closeNav;

document.addEventListener("keydown",e=>{
    if(e.key==="Escape") closeNav();
    if(navMenu.classList.contains("active") && e.key==="Tab"){
        const first=navLinks[0];
        const last=navLinks[navLinks.length-1];
        if(e.shiftKey && document.activeElement===first){
            e.preventDefault();last.focus();
        }else if(!e.shiftKey && document.activeElement===last){
            e.preventDefault();first.focus();
        }
    }
});

/* Swipe close */
navMenu.addEventListener("touchstart",e=>{
    startX=e.touches[0].clientX;
    startT=Date.now();
});
navMenu.addEventListener("touchend",e=>{
    const dx=startX-e.changedTouches[0].clientX;
    const dt=Date.now()-startT;
    if(dx>80 && dx/dt>0.35) closeNav();
});

/* Resize hardening */
window.addEventListener("resize",()=>{
    if(window.innerWidth>991) closeNav();
});

/* ================= DARK MODE (PERSIST) ================= */
const themeBtn=document.getElementById("themeToggle");
if(localStorage.theme==="dark"){
    document.body.classList.add("dark");
    themeBtn.innerHTML='<i class="bi bi-sun"></i>';
}
themeBtn.onclick=()=>{
    document.body.classList.toggle("dark");
    localStorage.theme=document.body.classList.contains("dark")?"dark":"light";
    themeBtn.innerHTML=document.body.classList.contains("dark")
        ?'<i class="bi bi-sun"></i>'
        :'<i class="bi bi-moon"></i>';
};

/* ================= PASSWORD ================= */
togglePass.onclick=()=>{
    password.type=password.type==="password"?"text":"password";
    togglePass.classList.toggle("bi-eye-slash");
};
password.addEventListener("keyup",e=>{
    capsWarn.style.display=e.getModifierState("CapsLock")?"block":"none";
});
</script>

</body>
</html>
