<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('course_forms', function (Blueprint $table) {
            $table->id();
            $table->string('student_id');
            $table->string('session');
            $table->string('semester');
            $table->integer('student_level');
            $table->dateTime('printed_on')->nullable();
            $table->integer('pc_ip')->nullable();
            $table->bigInteger('admin_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('course_forms');
    }
};
