@php
  use App\Models\Fee;use App\Models\Payment;$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Tuition')

@section('vendor-style')
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')}}">
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css')}}">
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css')}}">

@endsection

@section('vendor-script')
  <script src="{{asset('assets/vendor/libs/moment/moment.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js')}}"></script>
@endsection

@section('page-script')

  <script>
    $('#modalCenter').on('show.bs.modal',  function (event) {

      var button = $(event.relatedTarget); // Button that triggered the modal
      var lvl = button.data('level'); // Extract info from data-* attributes
      var yer = button.data('year');
      var sem = button.data('sem');
      var nsem = button.data('nsem');
      var famt = button.data('famount');
      var hamt = button.data('halfamt');
      var modal = $(this);
      modal.find('.modal-title').text('Pay Tuition for ' + lvl +"00 Level");
      modal.find('.modal-body input#paylvl').val(lvl);
      modal.find('.modal-body input#payyear').val(yer);
      modal.find('.modal-body input#paysem').val(sem);
      // modal.find('.modal-body input#semest').val(famt);
      modal.find('.modal-body #amt').text("₦ "+famt);
      modal.find('.modal-body #wsem').text("Part Payment ("+nsem+")");
      // modal.find('.modal-body input#semest2').val(hamt);
      modal.find('.modal-body #amt2').text("₦ "+hamt);

    });

    $("input:checkbox").on('click', function() {
      // in the handler, 'this' refers to the box clicked on
      var $box = $(this);
      if ($box.is(":checked")) {
        // the name of the box is retrieved using the .attr() method
        // as it is assumed and expected to be immutable
        var group = "input:checkbox[name='" + $box.attr("name") + "']";
        // the checked state of the group/box on the other hand will change
        // and the current value is retrieved using .prop() method
        $(group).prop("checked", false);
        $box.prop("checked", true);
      } else {
        $box.prop("checked", false);
      }
    });
  </script>
@endsection

@section('content')
  <h4 class="py-3 breadcrumb-wrapper mb-4">
    <span class="text-muted fw-light">Student /</span> Fees
  </h4>

@error('msg')
  <div class="alert alert-danger alert-dismissible d-flex align-items-center" role="alert">
    <i class="bx bx-xs bx-detail me-2"></i>
    {{$message }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
    </button>
  </div>

@enderror

  <!-- Bootstrap Table with Header - Dark -->
  <div class="card">
    {{--    <h5 class="card-header">Dark Table head</h5>--}}
    <div class="table-responsive text-nowrap">
      <table class="table">
        <thead class="table-dark">
        <tr>
          <th>Session</th>
          <th>Year</th>
          <th>Level</th>
          <th>Amount Payable</th>
          <th>Status</th>
          <th>Actions</th>
        </tr>
        </thead>
        <tbody class="table-border-bottom-0">
        @foreach($feehist as $f)
          <tr>
            <td><span class="fw-medium">{{$f->c_session}}</span></td>
            <td>
              {{$f->c_year}}
            </td>
            <td>
              {{$loop->iteration}}
            </td>
            <td>&#8358; {{Fee::getFee($user->department_id,$loop->iteration)->full_amount}}</td>
            @php
            $fee=Fee::getFee($user->department_id,$loop->iteration);
              $check=Payment::checkTuition($user->email,$f->c_year);
              if($check['pay'] == 1){
            @endphp
              <td><span class="badge bg-label-primary me-1">{{$check['paydit']->status}}</span></td>
              <td>
             <a class="btn btn-primary w-55 my-3" href="{{route("listrrr",$check['paydit']->id)}}"  style="color: white">View Payment</a>
{{--                <a class="btn btn-warning w-50 my-3" data-bs-toggle="dropdown" style="color: white">Verify Tuition</a>--}}
              </td>
@php
              }else{
@endphp
                 <td><span class="badge bg-label-primary me-1">NO RRR Yet</span></td>
              <td>
                <a class="btn btn-warning w-55 my-3 paytuit" data-bs-toggle="modal" style="color: white"
                   data-bs-target="#modalCenter" data-level="{{$loop->iteration}}" data-session="{{$f->c_session}}"
                   data-year="{{$f->c_year}}" data-sem="{{$semester->id}}" data-famount="{{$fee->full_amount}}" @if($semester->id==1) data-halfamt="{{$fee->first_semester_amount}}"
                   @else data-halfamt="{{$fee->second_semester_amount}}" @endif data-nsem="{{$semester->name}}">
                  Pay Tuition
                </a>
              </td>
            @php
              }
            @endphp
          </tr>
        @endforeach
        </tbody>
      </table>
    </div>
  </div>
  <!--/ Bootstrap Table with Header Dark -->

  <div class="modal fade" id="modalCenter" tabindex="-1" aria-hidden="true">
    <form method="post" action="{{route('paytuition')}}" >
      @csrf
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalCenterTitle">Pay Tuition</h5>
          <button
            type="button"
            class="btn-close"
            data-bs-dismiss="modal"
            aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="plevel" id="paylvl" value="">
          <input type="hidden" name="pyear" id="payyear" value="">
          <input type="hidden" name="psem" id="paysem" value="">
          <table class="table">

            <tbody class="table-border-bottom-0">
            <tr>
              <td>
                <div class="form-check mt-3">
                  <input class="form-check-input" checked type="checkbox" name="popt" value="0" id="semest" />

                </div>
              </td>
              <td>Full Payment</td>
              <td id="amt"></td>
            </tr>

            <tr>
              <td>
                <div class="form-check mt-3">
                  <input class="form-check-input" type="checkbox" name="popt" value="{{$semester->id}}" id="semest2" />
                </div>
              </td>
              <td id="wsem">Part Payment</td>
              <td id="amt2"></td>
            </tr>

            </tbody>

          </table>

        </div>
        <div class="modal-footer">

          <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">
            Close
          </button>
          <button type="submit" class="btn btn-primary">Get RRR</button>
        </div>
      </div>
    </div>

    </form>
  </div>

@endsection

